/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.util.UUIDTypeAdapter;
import com.skyblock.dynamic.nestworld.mods.NestworldModsServer;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.net.DeleteObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.MoveChapterGroupResponseMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.util.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class ServerQuestFile
extends BaseQuestFile {
    public static final LevelResource FTBQUESTS_DATA = new LevelResource("ftbquests");
    public static ServerQuestFile INSTANCE;
    public final MinecraftServer server;
    private boolean shouldSave;
    private boolean isLoading;
    private Path folder;
    private ServerPlayer currentPlayer = null;

    public ServerQuestFile(MinecraftServer s) {
        this.server = s;
        this.shouldSave = false;
        this.isLoading = false;
        int taskTypeId = 0;
        for (TaskType type : TaskTypes.TYPES.values()) {
            type.internalId = ++taskTypeId;
            this.taskTypeIds.put(type.internalId, (Object)type);
        }
        int rewardTypeId = 0;
        for (RewardType type : RewardTypes.TYPES.values()) {
            type.intId = ++rewardTypeId;
            this.rewardTypeIds.put(type.intId, (Object)type);
        }
    }

    public void load() {
        Path path;
        this.folder = Platform.getConfigFolder().resolve("ftbquests/quests");
        if (Files.exists(this.folder, new LinkOption[0])) {
            FTBQuests.LOGGER.info("Loading quests from " + String.valueOf(this.folder));
            this.isLoading = true;
            this.readDataFull(this.folder);
            this.isLoading = false;
        }
        if (Files.exists(path = this.server.m_129843_(FTBQUESTS_DATA), new LinkOption[0])) {
            try (Stream<Path> s = Files.list(path);){
                s.filter(p -> p.getFileName().toString().contains("-") && p.getFileName().toString().endsWith(".snbt")).forEach(path1 -> {
                    SNBTCompoundTag nbt = SNBT.read((Path)path1);
                    if (nbt != null) {
                        try {
                            UUID uuid = UUIDTypeAdapter.fromString((String)nbt.m_128461_("uuid"));
                            IslandData data = new IslandData(uuid, this);
                            this.addData(data, true);
                            data.deserializeNBT(nbt);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Env getSide() {
        return Env.SERVER;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public Path getFolder() {
        return this.folder;
    }

    @Override
    public void deleteObject(long id) {
        QuestObjectBase object = this.getBase(id);
        if (object != null) {
            object.deleteChildren();
            object.deleteSelf();
            this.refreshIDMap();
            this.markDirty();
            object.getPath().ifPresent(path -> FileUtils.delete(this.getFolder().resolve((String)path).toFile()));
        }
        new DeleteObjectResponseMessage(id).sendToAll(this.server);
    }

    @Override
    public void markDirty() {
        this.shouldSave = true;
    }

    public void saveNow() {
        if (this.shouldSave) {
            this.writeDataFull(this.getFolder());
            this.shouldSave = false;
        }
        this.getAllIslandData().forEach(IslandData::saveIfChanged);
    }

    public void unload() {
        this.saveNow();
        this.deleteChildren();
        this.deleteSelf();
    }

    public ServerPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void withPlayerContext(ServerPlayer player, Runnable toDo) {
        this.currentPlayer = player;
        try {
            toDo.run();
        }
        finally {
            this.currentPlayer = null;
        }
    }

    @Override
    public boolean isPlayerOnTeam(Player player, IslandData islandData) {
        UUID playerTeamId = NestworldModsServer.ISLAND_PROVIDER.getCachedTeamId(player.m_20148_());
        return playerTeamId != null && playerTeamId.equals(islandData.getTeamId());
    }

    @Override
    public boolean moveChapterGroup(long id, boolean movingUp) {
        if (super.moveChapterGroup(id, movingUp)) {
            this.markDirty();
            this.clearCachedData();
            new MoveChapterGroupResponseMessage(id, movingUp).sendToAll(this.server);
            return true;
        }
        return false;
    }

    public IslandData getIslandData(UUID islandOwnerUuid) {
        if (islandOwnerUuid == null) {
            return null;
        }
        for (IslandData data : this.getAllIslandData()) {
            if (!data.getTeamId().equals(islandOwnerUuid)) continue;
            return data;
        }
        return null;
    }
}

