/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class QuestObject
extends QuestObjectBase {
    protected boolean disableToast = false;

    public QuestObject(long id) {
        super(id);
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        if (this.disableToast) {
            nbt.m_128379_("disable_toast", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.disableToast = nbt.m_128471_("disable_toast");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeBoolean(this.disableToast);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.disableToast = buffer.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addBool("disable_toast", this.disableToast, v -> {
            this.disableToast = v;
        }, false).setNameKey("ftbquests.disable_completion_toast").setCanEdit(this.getQuestChapter() == null || !this.getQuestChapter().isAlwaysInvisible()).setOrder(127);
    }

    @Override
    public void forceProgress(IslandData islandData, ProgressChange progressChange) {
        if (progressChange.shouldReset()) {
            islandData.setStarted(this.id, null);
            islandData.setCompleted(this.id, null);
        } else {
            islandData.setStarted(this.id, progressChange.getDate());
            islandData.setCompleted(this.id, progressChange.getDate());
        }
        for (QuestObject questObject : this.getChildren()) {
            questObject.forceProgress(islandData, progressChange);
        }
    }

    public abstract int getRelativeProgressFromChildren(IslandData var1);

    public boolean cacheProgress() {
        return true;
    }

    public static int getRelativeProgressFromChildren(int progressSum, int count) {
        if (count <= 0 || progressSum <= 0) {
            return 0;
        }
        if (progressSum >= count * 100) {
            return 100;
        }
        return Math.max(1, (int)((double)progressSum / (double)count));
    }

    public boolean isVisible(IslandData data) {
        return true;
    }

    public boolean isSearchable(IslandData data) {
        return this.isVisible(data);
    }

    public void onStarted(QuestProgressEventData<?> data) {
    }

    public void onCompleted(QuestProgressEventData<?> data) {
    }

    protected void verifyDependenciesInternal(long original, int depth) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color4I getProgressColor(IslandData data) {
        if (data.isCompleted(this)) {
            return (Color4I)ThemeProperties.QUEST_COMPLETED_COLOR.get();
        }
        if (data.isStarted(this)) {
            return (Color4I)ThemeProperties.QUEST_STARTED_COLOR.get();
        }
        return Color4I.WHITE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color4I getProgressColor(IslandData data, boolean dim) {
        Color4I c = this.getProgressColor(data);
        return dim ? c.addBrightness(-0.35f) : c;
    }

    public Collection<? extends QuestObject> getChildren() {
        return List.of();
    }

    public boolean isCompletedRaw(IslandData data) {
        int nOptional = 0;
        int nCompleted = 0;
        for (QuestObject questObject : this.getChildren()) {
            boolean uncompleted;
            boolean bl = uncompleted = !data.isCompleted(questObject) && !data.isExcludedByOtherQuestline(questObject);
            if (uncompleted) {
                if (questObject.isOptionalForProgression()) {
                    ++nOptional;
                    continue;
                }
                return false;
            }
            ++nCompleted;
        }
        return this.getChildren().isEmpty() || nOptional < this.getChildren().size() || nCompleted > 0;
    }

    public boolean isOptionalForProgression() {
        return false;
    }

    public boolean hasUnclaimedRewardsRaw(IslandData islandData, UUID player) {
        return false;
    }
}

