/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.net.TogglePinnedResponseMessage;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class TogglePinnedMessage
extends BaseC2SMessage {
    private final long id;

    TogglePinnedMessage(FriendlyByteBuf buffer) {
        this.id = buffer.readLong();
    }

    public TogglePinnedMessage(long i) {
        this.id = i;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.TOGGLE_PINNED;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.id);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        IslandData data = ServerQuestFile.INSTANCE.getOrCreateIslandData((Entity)player);
        boolean newPinned = !data.isQuestPinned((Player)player, this.id);
        data.setQuestPinned((Player)player, this.id, newPinned);
        new TogglePinnedResponseMessage(this.id, newPinned).sendTo(player);
    }
}

