/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import com.skyblock.dynamic.SkyBlockMod;
import com.skyblock.dynamic.utils.QuestTeamBridge;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class SubmitTaskMessage
extends BaseC2SMessage {
    private final long taskId;

    SubmitTaskMessage(FriendlyByteBuf buffer) {
        this.taskId = buffer.readLong();
    }

    public SubmitTaskMessage(long taskId) {
        this.taskId = taskId;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.SUBMIT_TASK;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.taskId);
    }

    public void handle(NetworkManager.PacketContext context) {
        boolean hasPermission;
        UUID islandOwnerUuid;
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        Task task = ServerQuestFile.INSTANCE.getTask(this.taskId);
        if (task == null || !SkyBlockMod.isIslandServer()) {
            return;
        }
        try {
            islandOwnerUuid = UUID.fromString(SkyBlockMod.getCreatorUuid());
        }
        catch (IllegalArgumentException e) {
            return;
        }
        IslandData islandData = ServerQuestFile.INSTANCE.getIslandData(islandOwnerUuid);
        if (islandData != null && islandData != IslandData.UNLOADED && !islandData.isLocked() && islandData.canStartTasks(task.getQuest()) && (hasPermission = QuestTeamBridge.getInstance().isPlayerOnTeam(player.m_20148_(), islandOwnerUuid))) {
            ServerQuestFile.INSTANCE.withPlayerContext(player, () -> task.submitTask(islandData, player));
        }
    }
}

