/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import com.skyblock.dynamic.SkyBlockMod;
import com.skyblock.dynamic.utils.QuestTeamBridge;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ClaimRewardMessage
extends BaseC2SMessage {
    private final long id;
    private final boolean notify;

    ClaimRewardMessage(FriendlyByteBuf buffer) {
        this.id = buffer.readLong();
        this.notify = buffer.readBoolean();
    }

    public ClaimRewardMessage(long i, boolean n) {
        this.id = i;
        this.notify = n;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CLAIM_REWARD;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.id);
        buffer.writeBoolean(this.notify);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        Reward reward = ServerQuestFile.INSTANCE.getReward(this.id);
        if (reward == null) {
            return;
        }
        IslandData islandData = ServerQuestFile.INSTANCE.getOrCreateIslandData((Entity)player);
        if (islandData != null && islandData.isCompleted(reward.getQuest())) {
            boolean isCorrectIsland;
            boolean isMember = QuestTeamBridge.getInstance().isPlayerOnTeam(player.m_20148_(), islandData.getTeamId());
            boolean bl = isCorrectIsland = !SkyBlockMod.isIslandServer() || UUID.fromString(SkyBlockMod.getCreatorUuid()).equals(islandData.getTeamId());
            if (isMember && isCorrectIsland) {
                islandData.claimReward(player, reward, this.notify);
            }
        }
    }
}

