/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;

public class ChangeProgressMessage
extends BaseC2SMessage {
    private final UUID islandId;
    private final ProgressChange progressChange;

    ChangeProgressMessage(FriendlyByteBuf buffer) {
        this.islandId = buffer.m_130259_();
        this.progressChange = new ProgressChange(ServerQuestFile.INSTANCE, buffer);
    }

    public ChangeProgressMessage(UUID islandId, ProgressChange progressChange) {
        this.islandId = islandId;
        this.progressChange = progressChange;
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CHANGE_PROGRESS;
    }

    public static void sendToServer(IslandData island, QuestObjectBase object, Consumer<ProgressChange> progressChange) {
        if (island.isLocked()) {
            return;
        }
        ProgressChange change = new ProgressChange(island.getFile(), object, FTBQuestsClient.getClientPlayer().m_20148_());
        progressChange.accept(change);
        new ChangeProgressMessage(island.getTeamId(), change).sendToServer();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.islandId);
        this.progressChange.write(buffer);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (NetUtils.canEdit(context)) {
            this.progressChange.maybeForceProgress(this.islandId);
        }
    }
}

