/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.forge;

import dev.architectury.platform.forge.EventBuses;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.api.FTBQuestsTags;
import dev.ftb.mods.ftbquests.forge.ClientSetup;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.task.forge.ForgeEnergyTask;
import java.util.Iterator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="ftbquests")
public class FTBQuestsForge {
    public FTBQuestsForge() {
        EventBuses.registerModEventBus((String)"ftbquests", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        FTBQuests quests = new FTBQuests();
        ForgeEnergyTask.TYPE = TaskTypes.register(new ResourceLocation("ftbquests", "forge_energy"), ForgeEnergyTask::new, () -> Icon.getIcon((String)ForgeEnergyTask.EMPTY_TEXTURE.toString()).combineWith(Icon.getIcon((String)ForgeEnergyTask.FULL_TEXTURE.toString())));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> quests.setup());
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSetup::init);
        MinecraftForge.EVENT_BUS.addListener(FTBQuestsForge::livingDrops);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, FTBQuestsForge::dropsEvent);
    }

    private static void livingDrops(LivingDropsEvent event) {
        LivingEntity living = event.getEntity();
        if (living.m_9236_().f_46443_ || living instanceof Player || living.m_6095_().m_204039_(FTBQuestsTags.EntityTypes.NO_LOOT_CRATES)) {
            return;
        }
        if (ServerQuestFile.INSTANCE == null || !ServerQuestFile.INSTANCE.isDropLootCrates()) {
            return;
        }
        ServerQuestFile.INSTANCE.makeRandomLootCrate((Entity)living, living.m_9236_().f_46441_).ifPresent(crate -> {
            ItemEntity itemEntity = new ItemEntity(living.m_9236_(), living.m_20185_(), living.m_20186_(), living.m_20189_(), crate.createStack());
            itemEntity.m_32010_(10);
            event.getDrops().add(itemEntity);
        });
    }

    private static void dropsEvent(LivingDropsEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity) instanceof FakePlayer || player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || ServerQuestFile.INSTANCE.dropBookOnDeath()) {
            return;
        }
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemEntity drop = (ItemEntity)iterator.next();
            ItemStack stack = drop.m_32055_();
            if (stack.m_41720_() != FTBQuestsItems.BOOK.get() || !player.m_36356_(stack)) continue;
            iterator.remove();
        }
    }
}

