/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.events;

import dev.ftb.mods.ftbquests.net.DisplayCompletionToastMessage;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;

public final class QuestProgressEventData<T extends QuestObject> {
    private final Date time;
    private final IslandData islandData;
    private final T object;
    private final List<ServerPlayer> onlineMembers;
    private final List<ServerPlayer> notifiedPlayers;

    public QuestProgressEventData(Date date, IslandData islandData, T object, Collection<ServerPlayer> online, Collection<ServerPlayer> notified) {
        this.time = date;
        this.islandData = islandData;
        this.object = object;
        this.onlineMembers = new ArrayList<ServerPlayer>(online);
        this.notifiedPlayers = new ArrayList<ServerPlayer>(notified);
    }

    public void setStarted(long id) {
        this.islandData.setStarted(id, this.time);
    }

    public void setCompleted(long id) {
        this.islandData.setCompleted(id, this.time);
    }

    public void notifyPlayers(long id) {
        this.notifiedPlayers.forEach(player -> new DisplayCompletionToastMessage(id).sendTo((ServerPlayer)player));
    }

    public Date getTime() {
        return this.time;
    }

    public IslandData getIslandData() {
        return this.islandData;
    }

    public T getObject() {
        return this.object;
    }

    public List<ServerPlayer> getOnlineMembers() {
        return this.onlineMembers;
    }

    public List<ServerPlayer> getNotifiedPlayers() {
        return this.notifiedPlayers;
    }

    public <N extends QuestObject> QuestProgressEventData<N> withObject(N o) {
        return this.object == o ? this : new QuestProgressEventData<N>(this.time, this.islandData, o, this.onlineMembers, this.notifiedPlayers);
    }
}

