/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbquests.quest.team.TeamData;
import dev.ftb.mods.ftbquests.quest.team.TeamManager;
import dev.ftb.mods.ftbquests.util.TeamHttpClient;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TeamCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"team").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> TeamCommands.createTeam((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommands.invitePlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"join").then(Commands.m_82129_((String)"team_owner", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommands.joinTeam((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"team_owner")))))).then(Commands.m_82127_((String)"leave").executes(context -> TeamCommands.leaveTeam((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> TeamCommands.kickPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))));
    }

    private static int createTeam(CommandSourceStack source, String name) {
        ServerPlayer player;
        try {
            player = source.m_81375_();
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be run by a player."));
            return 0;
        }
        TeamManager teamManager = TeamManager.getInstance(source.m_81377_());
        if (teamManager.getPlayerTeam(player.m_20148_()) != null) {
            source.m_81352_((Component)Component.m_237113_((String)"You are already in a team."));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Creating team..."), false);
        TeamHttpClient.notifyTeamCreated(player.m_20148_(), name).thenAccept(success -> player.m_20194_().execute(() -> {
            if (success.booleanValue()) {
                TeamData team = teamManager.createTeam(name, player.m_20148_());
                if (team != null) {
                    player.m_213846_((Component)Component.m_237113_((String)("Team '" + name + "' created successfully!")));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Failed to create team locally. Perhaps you joined a team just now?"));
                }
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Failed to create team. The backend service rejected the request."));
            }
        }));
        return 1;
    }

    private static int invitePlayer(CommandSourceStack source, ServerPlayer invitedPlayer) {
        ServerPlayer owner;
        try {
            owner = source.m_81375_();
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be run by a player."));
            return 0;
        }
        TeamManager teamManager = TeamManager.getInstance(source.m_81377_());
        TeamData team = teamManager.getPlayerTeam(owner.m_20148_());
        if (team == null || !team.getRole(owner.m_20148_()).isLeader()) {
            source.m_81352_((Component)Component.m_237113_((String)"You are not the leader of a team."));
            return 0;
        }
        if (teamManager.getPlayerTeam(invitedPlayer.m_20148_()) != null) {
            source.m_81352_((Component)Component.m_237113_((String)(invitedPlayer.m_7755_().getString() + " is already in a team.")));
            return 0;
        }
        teamManager.addInvitation(invitedPlayer.m_20148_(), team.getId());
        source.m_288197_(() -> Component.m_237113_((String)("Invited " + invitedPlayer.m_7755_().getString() + " to the team.")), false);
        invitedPlayer.m_213846_((Component)Component.m_237113_((String)("You have been invited to join '" + team.getName() + "'. Type /team join " + owner.m_7755_().getString() + " to accept.")));
        return 1;
    }

    private static int joinTeam(CommandSourceStack source, ServerPlayer teamOwner) {
        ServerPlayer player;
        try {
            player = source.m_81375_();
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be run by a player."));
            return 0;
        }
        TeamManager teamManager = TeamManager.getInstance(source.m_81377_());
        UUID teamId = teamManager.getInvitation(player.m_20148_());
        TeamData team = teamManager.getTeam(teamId);
        if (team == null || !team.getOwner().equals(teamOwner.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"You don't have an invitation to join this team."));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Attempting to join team... Archiving your island..."), false);
        TeamHttpClient.notifyIslandAction(player.m_20148_(), "archive").thenAccept(success -> player.m_20194_().execute(() -> {
            if (success.booleanValue()) {
                teamManager.addPlayerToTeam(player.m_20148_(), team);
                player.m_213846_((Component)Component.m_237113_((String)("Successfully joined team '" + team.getName() + "'!")));
                teamOwner.m_213846_((Component)Component.m_237113_((String)(player.m_7755_().getString() + " has joined your team.")));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Failed to join team: Could not archive your island."));
            }
        }));
        return 1;
    }

    private static int leaveTeam(CommandSourceStack source) {
        ServerPlayer player;
        try {
            player = source.m_81375_();
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be run by a player."));
            return 0;
        }
        TeamManager teamManager = TeamManager.getInstance(source.m_81377_());
        TeamData team = teamManager.getPlayerTeam(player.m_20148_());
        if (team == null) {
            source.m_81352_((Component)Component.m_237113_((String)"You are not in a team."));
            return 0;
        }
        if (team.getOwner().equals(player.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"You are the owner. You must disband the team or transfer ownership. (Disband not implemented yet)"));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Leaving team... Restoring your island..."), false);
        TeamHttpClient.notifyIslandAction(player.m_20148_(), "restore").thenAccept(success -> player.m_20194_().execute(() -> {
            if (success.booleanValue()) {
                teamManager.removePlayerFromTeam(player.m_20148_());
                player.m_213846_((Component)Component.m_237113_((String)"You have left the team."));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Failed to leave team: Could not restore your island."));
            }
        }));
        return 1;
    }

    private static int kickPlayer(CommandSourceStack source, ServerPlayer playerToKick) {
        ServerPlayer owner;
        try {
            owner = source.m_81375_();
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be run by a player."));
            return 0;
        }
        TeamManager teamManager = TeamManager.getInstance(source.m_81377_());
        TeamData team = teamManager.getPlayerTeam(owner.m_20148_());
        if (team == null || !team.getRole(owner.m_20148_()).isLeader()) {
            source.m_81352_((Component)Component.m_237113_((String)"You are not the leader of a team."));
            return 0;
        }
        if (!team.isMember(playerToKick.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)(playerToKick.m_7755_().getString() + " is not in your team.")));
            return 0;
        }
        if (owner.m_20148_().equals(playerToKick.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"You cannot kick yourself."));
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Kicking player... Restoring their island..."), false);
        TeamHttpClient.notifyIslandAction(playerToKick.m_20148_(), "restore").thenAccept(success -> owner.m_20194_().execute(() -> {
            if (success.booleanValue()) {
                teamManager.removePlayerFromTeam(playerToKick.m_20148_());
                owner.m_213846_((Component)Component.m_237113_((String)("You have kicked " + playerToKick.m_7755_().getString() + " from the team.")));
                playerToKick.m_213846_((Component)Component.m_237113_((String)("You have been kicked from the team '" + team.getName() + "'.")));
            } else {
                owner.m_213846_((Component)Component.m_237113_((String)"Failed to kick player: Could not restore their island."));
            }
        }));
        return 1;
    }
}

