/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.hooks.item.ItemStackHooks;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.IRewardListenerScreen;
import dev.ftb.mods.ftbquests.client.gui.QuestObjectUpdateListener;
import dev.ftb.mods.ftbquests.client.gui.RewardKey;
import dev.ftb.mods.ftbquests.client.gui.RewardToast;
import dev.ftb.mods.ftbquests.client.gui.ToastQuestObject;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.net.IslandDataUpdate;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.IslandData;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.Date;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FTBQuestsNetClient {
    public static void syncIslandData(boolean self, IslandData data) {
        ClientQuestFile.INSTANCE.addData(data, true);
        if (self) {
            ClientQuestFile.INSTANCE.selfTeamData = data;
        }
    }

    public static void claimReward(UUID islandId, UUID player, long rewardId) {
        QuestScreen treeGui;
        Reward reward = ClientQuestFile.INSTANCE.getReward(rewardId);
        if (reward == null) {
            return;
        }
        IslandData data = ClientQuestFile.INSTANCE.getOrCreateIslandData(islandId);
        data.claimReward(player, reward, System.currentTimeMillis());
        if (data == ClientQuestFile.INSTANCE.selfTeamData && (treeGui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class))) != null) {
            treeGui.refreshViewQuestPanel();
            treeGui.otherButtonsTopPanel.refreshWidgets();
        }
    }

    public static void createObject(long id, long parent, QuestObjectType type, CompoundTag nbt, @Nullable CompoundTag extra, UUID creator) {
        QuestObjectUpdateListener listener;
        QuestObjectBase object = ClientQuestFile.INSTANCE.create(id, type, parent, extra == null ? new CompoundTag() : extra);
        object.readData(nbt);
        object.onCreated();
        ClientQuestFile.INSTANCE.refreshIDMap();
        object.editedFromGUI();
        FTBQuests.getRecipeModHelper().refreshRecipes(object);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (object instanceof QuestObject) {
            QuestObject qo = (QuestObject)object;
            if (player != null && creator.equals(player.m_20148_())) {
                ClientQuestFile.INSTANCE.getQuestScreen().ifPresent(questScreen -> questScreen.open(qo, true));
            }
        }
        if ((listener = (QuestObjectUpdateListener)ClientUtils.getCurrentGuiAs(QuestObjectUpdateListener.class)) != null) {
            listener.onQuestObjectUpdate(object);
        }
    }

    public static void createOtherIslandData(IslandDataUpdate dataUpdate) {
        if (ClientQuestFile.INSTANCE != null) {
            IslandData data = new IslandData(dataUpdate.uuid, ClientQuestFile.INSTANCE, dataUpdate.name);
            ClientQuestFile.INSTANCE.addData(data, true);
        }
    }

    public static void islandDataChanged(IslandDataUpdate oldDataUpdate, IslandDataUpdate newDataUpdate) {
        if (ClientQuestFile.INSTANCE != null) {
            IslandData data = new IslandData(newDataUpdate.uuid, ClientQuestFile.INSTANCE, newDataUpdate.name);
            ClientQuestFile.INSTANCE.addData(data, false);
        }
    }

    public static void deleteObject(long id) {
        QuestObjectBase object = ClientQuestFile.INSTANCE.getBase(id);
        if (object != null) {
            object.deleteChildren();
            object.deleteSelf();
            ClientQuestFile.INSTANCE.refreshIDMap();
            object.editedFromGUI();
            FTBQuests.getRecipeModHelper().refreshRecipes(object);
        }
    }

    public static void displayCompletionToast(long id) {
        QuestScreen questScreen;
        QuestObject object = ClientQuestFile.INSTANCE.get(id);
        if (object != null) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastQuestObject(object));
        }
        if ((questScreen = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class))) != null) {
            questScreen.refreshQuestPanel();
            questScreen.refreshChapterPanel();
            questScreen.refreshViewQuestPanel();
        }
    }

    public static void displayItemRewardToast(ItemStack stack, int count) {
        ItemStack stack1 = ItemStackHooks.copyWithCount((ItemStack)stack, (int)1);
        Icon icon = ItemIcon.getItemIcon((ItemStack)stack1);
        if (!IRewardListenerScreen.add(new RewardKey(stack.m_41786_().getString(), icon, stack1), count)) {
            MutableComponent comp = count > 1 ? Component.m_237113_((String)(count + "x ")).m_7220_(stack.m_41786_()) : stack.m_41786_().m_6881_();
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new RewardToast((Component)comp.m_130940_(stack.m_41791_().f_43022_), icon));
        }
    }

    public static void displayRewardToast(long id, Component text, Icon icon) {
        Icon i;
        Icon icon2 = i = icon.isEmpty() ? ClientQuestFile.INSTANCE.getBase(id).getIcon() : icon;
        if (!IRewardListenerScreen.add(new RewardKey(text.getString(), i), 1)) {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new RewardToast(text, i));
        }
    }

    public static void editObject(long id, CompoundTag nbt) {
        ClientQuestFile.INSTANCE.clearCachedData();
        QuestObjectBase object = ClientQuestFile.INSTANCE.getBase(id);
        if (object != null) {
            object.readData(nbt);
            object.editedFromGUI();
            FTBQuests.getRecipeModHelper().refreshRecipes(object);
        }
    }

    public static void moveChapter(long id, boolean movingUp) {
        Chapter chapter = ClientQuestFile.INSTANCE.getChapter(id);
        if (chapter != null && chapter.getGroup().moveChapterWithinGroup(chapter, movingUp)) {
            ClientQuestFile.INSTANCE.clearCachedData();
            QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
            if (gui != null) {
                gui.refreshChapterPanel();
            }
        }
    }

    public static void moveQuest(long id, long chapter, double x, double y) {
        QuestObject questObject = ClientQuestFile.INSTANCE.get(id);
        if (questObject instanceof Movable) {
            Movable movable = (Movable)((Object)questObject);
            movable.onMoved(x, y, chapter);
            QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
            if (gui != null) {
                gui.questPanel.withPreservedPos(Panel::refreshWidgets);
            }
        }
    }

    public static void syncEditingMode(UUID islandId, boolean editingMode) {
        if (ClientQuestFile.INSTANCE.getOrCreateIslandData(islandId).setCanEdit((Player)Minecraft.m_91087_().f_91074_, editingMode)) {
            FTBQuestsNetClient.setEditorPermission(editingMode);
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }

    public static void togglePinned(long id, boolean pinned) {
        IslandData data = FTBQuestsClient.getClientPlayerData();
        data.setQuestPinned((Player)Minecraft.m_91087_().f_91074_, id, pinned);
        ClientQuestFile.INSTANCE.getQuestScreen().ifPresent(questScreen -> {
            questScreen.otherButtonsTopPanel.refreshWidgets();
            questScreen.refreshViewQuestPanel();
        });
    }

    public static void updateIslandData(UUID islandId, String name) {
        IslandData data = ClientQuestFile.INSTANCE.getOrCreateIslandData(islandId);
        data.setName(name);
    }

    public static void updateTaskProgress(UUID islandId, long task, long progress) {
        Task t = ClientQuestFile.INSTANCE.getTask(task);
        if (t != null) {
            IslandData data = ClientQuestFile.INSTANCE.getOrCreateIslandData(islandId);
            ClientQuestFile.INSTANCE.clearCachedProgress();
            data.setProgress(t, progress);
        }
    }

    public static void changeChapterGroup(long id, long newGroupId) {
        Chapter chapter = ClientQuestFile.INSTANCE.getChapter(id);
        if (chapter != null) {
            ChapterGroup newGroup = ClientQuestFile.INSTANCE.getChapterGroup(newGroupId);
            if (chapter.getGroup() != newGroup) {
                chapter.getGroup().removeChapter(chapter);
                newGroup.addChapter(chapter);
                chapter.file.clearCachedData();
                chapter.editedFromGUI();
            }
        }
    }

    public static void moveChapterGroup(long id, boolean movingUp) {
        ClientQuestFile.INSTANCE.moveChapterGroup(id, movingUp);
    }

    public static void objectStarted(UUID islandId, long id, @Nullable Date time) {
        IslandData islandData = ClientQuestFile.INSTANCE.getOrCreateIslandData(islandId);
        islandData.setStarted(id, time);
        FTBQuestsNetClient.refreshQuestScreenIfOpen();
    }

    public static void objectCompleted(UUID islandId, long id, @Nullable Date time) {
        IslandData islandData = ClientQuestFile.INSTANCE.getOrCreateIslandData(islandId);
        islandData.setCompleted(id, time);
        FTBQuestsNetClient.refreshQuestScreenIfOpen();
        FTBQuests.getRecipeModHelper().refreshRecipes(ClientQuestFile.INSTANCE.get(id));
    }

    public static void syncLock(UUID id, boolean lock) {
        if (ClientQuestFile.INSTANCE.getOrCreateIslandData(id).setLocked(lock)) {
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }

    public static void resetReward(UUID islandId, UUID player, long rewardId) {
        IslandData islandData;
        Reward reward = ClientQuestFile.INSTANCE.getReward(rewardId);
        if (reward != null && (islandData = ClientQuestFile.INSTANCE.getOrCreateIslandData(islandId)).resetReward(player, reward)) {
            FTBQuestsNetClient.refreshQuestScreenIfOpen();
        }
    }

    private static void refreshQuestScreenIfOpen() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.refreshChapterPanel();
            gui.refreshViewQuestPanel();
        }
    }

    public static void toggleChapterPinned(boolean pinned) {
        ClientQuestFile.INSTANCE.selfTeamData.setChapterPinned(FTBQuestsClient.getClientPlayer(), pinned);
        ClientQuestFile.INSTANCE.getQuestScreen().ifPresent(QuestScreen::refreshChapterPanel);
    }

    public static void syncRewardBlocking(UUID islandId, boolean rewardsBlocked) {
        if (ClientQuestFile.INSTANCE.getOrCreateIslandData(islandId).setRewardsBlocked(rewardsBlocked)) {
            ClientQuestFile.INSTANCE.refreshGui();
        }
    }

    public static void setEditorPermission(boolean hasPermission) {
        if (ClientQuestFile.exists()) {
            ClientQuestFile.INSTANCE.setEditorPermission(hasPermission);
        }
    }
}

