/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftbquests.block.FTBQuestsBlocks;
import dev.ftb.mods.ftbquests.block.entity.ITaskScreen;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenAuxBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.block.forge.TaskScreenBlockImpl;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.item.ScreenBlockItem;
import dev.ftb.mods.ftbquests.net.TaskScreenConfigRequest;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TaskScreenBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private final int size;

    protected TaskScreenBlock(int size) {
        super(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.BLACK).m_60978_(0.3f));
        this.size = size;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public int getSize() {
        return this.size;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return TaskScreenBlock.blockEntityProvider().m_155267_(blockPos, blockState);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<TaskScreenBlockEntity> blockEntityProvider() {
        return TaskScreenBlockImpl.blockEntityProvider();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<TaskScreenAuxBlockEntity> blockEntityAuxProvider() {
        return TaskScreenBlockImpl.blockEntityAuxProvider();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        if (!this.validatePlaceable(blockPlaceContext)) {
            return null;
        }
        return (BlockState)super.m_5573_(blockPlaceContext).m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    private boolean validatePlaceable(BlockPlaceContext ctx) {
        int screenSize = ScreenBlockItem.getSize(ctx.m_43722_());
        if (screenSize == 1) {
            return true;
        }
        Direction facing = ctx.m_8125_();
        return BlockPos.m_121921_((AABB)TaskScreenBlock.getMultiblockBounds(ctx.m_8083_(), this.getSize(), facing)).allMatch(pos -> ctx.m_43725_().m_8055_(pos).m_60629_(ctx));
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof TaskScreenBlockEntity) {
            TaskScreenBlockEntity coreScreen = (TaskScreenBlockEntity)blockEntity;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)livingEntity;
                coreScreen.setTeamId(ServerQuestFile.INSTANCE.getOrCreateIslandData((Entity)sp).getTeamId());
            }
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            BlockState auxState = (BlockState)((Block)FTBQuestsBlocks.AUX_SCREEN.get()).m_49966_().m_61124_((Property)FACING, (Comparable)facing);
            BlockPos.m_121921_((AABB)TaskScreenBlock.getMultiblockBounds(blockPos, this.getSize(), facing)).filter(pos -> !pos.equals((Object)blockPos)).forEach(auxPos -> {
                level.m_46597_(auxPos, auxState);
                BlockEntity patt5143$temp = level.m_7702_(auxPos);
                if (patt5143$temp instanceof TaskScreenAuxBlockEntity) {
                    TaskScreenAuxBlockEntity auxScreen = (TaskScreenAuxBlockEntity)patt5143$temp;
                    auxScreen.setCoreScreen(coreScreen);
                }
            });
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (blockState.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(blockPos)) instanceof ITaskScreen) {
            ITaskScreen taskScreen = (ITaskScreen)blockEntity;
            taskScreen.getCoreScreen().ifPresent(coreScreen -> {
                coreScreen.removeAllAuxScreens();
                if (coreScreen != taskScreen) {
                    level.m_46953_(coreScreen.m_58899_(), true, null);
                }
            });
            super.m_6810_(blockState, level, blockPos, newState, isMoving);
        }
    }

    public float m_5880_(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        ITaskScreen taskScreen;
        BlockEntity blockEntity = player.m_9236_().m_7702_(blockPos);
        if (blockEntity instanceof ITaskScreen && (taskScreen = (ITaskScreen)blockEntity).isIndestructible()) {
            return 0.0f;
        }
        return super.m_5880_(blockState, player, blockGetter, blockPos);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof ITaskScreen) {
                ITaskScreen taskScreen = (ITaskScreen)blockEntity;
                if (TaskScreenBlock.hasPermissionToEdit(sp, taskScreen)) {
                    taskScreen.getCoreScreen().ifPresent(coreScreen -> new TaskScreenConfigRequest(coreScreen.m_58899_()).sendTo(sp));
                } else {
                    sp.m_5661_((Component)Component.m_237115_((String)"block.ftbquests.screen.no_permission").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_5871_(itemStack, blockGetter, list, tooltipFlag);
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("BlockEntityTag", 10)) {
            Task task;
            CompoundTag subTag = Objects.requireNonNull(itemStack.m_41737_("BlockEntityTag"));
            BaseQuestFile questFile = FTBQuestsClient.getClientQuestFile();
            if (questFile != null && (task = questFile.getTask(subTag.m_128454_("TaskID"))) != null) {
                list.add((Component)Component.m_237115_((String)"ftbquests.chapter").m_130946_(": ").m_7220_((Component)task.getQuest().getChapter().getTitle().m_6881_().m_130940_(ChatFormatting.YELLOW)));
                list.add((Component)Component.m_237115_((String)"ftbquests.quest").m_130946_(": ").m_7220_((Component)task.getQuest().getMutableTitle().m_130940_(ChatFormatting.YELLOW)));
                list.add((Component)Component.m_237115_((String)"ftbquests.task").m_130946_(": ").m_7220_((Component)task.getMutableTitle().m_130940_(ChatFormatting.YELLOW)));
            }
        }
    }

    public static boolean hasPermissionToEdit(ServerPlayer player, ITaskScreen screen) {
        return player.m_20148_().equals(screen.getTeamId());
    }

    public static AABB getMultiblockBounds(BlockPos corePos, int size, Direction facing) {
        if (size == 1) {
            return new AABB(corePos, corePos);
        }
        int size2 = size / 2;
        facing = facing.m_122428_();
        return new AABB((double)(corePos.m_123341_() - size2 * facing.m_122429_()), (double)corePos.m_123342_(), (double)(corePos.m_123343_() - size2 * facing.m_122431_()), (double)(corePos.m_123341_() + size2 * facing.m_122429_()), (double)(corePos.m_123342_() + size - 1), (double)(corePos.m_123343_() + size2 * facing.m_122431_()));
    }

    public static class Aux
    extends TaskScreenBlock {
        protected Aux() {
            super(0);
        }

        @Override
        @Nullable
        public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
            return Aux.blockEntityAuxProvider().m_155267_(blockPos, blockState);
        }
    }
}

