/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.SeatBlock;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class CushionBlock
extends SeatBlock {
    public static final VoxelShape ROYAL_FLOOR_CUSHION_SHAPE = CushionBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    public static final VoxelShaper ROYAL_FLOOR_CUSHION_SHAPER = VoxelShaper.forHorizontal((VoxelShape)ROYAL_FLOOR_CUSHION_SHAPE, (Direction)Direction.NORTH);

    public CushionBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
    }

    public double getSeatYOffset(BlockState blockState) {
        if (AllBlocks.ROYAL_FLOOR_CUSHION.isIn(blockState)) {
            return 0.0;
        }
        if (AllBlocks.ROYAL_CUSHION.isIn(blockState)) {
            return 0.3;
        }
        return 0.2;
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos pos, Entity entity, float distance) {
        super.m_142072_(level, blockState, pos, entity, distance * 0.5f);
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    protected void bounceUp(Entity entity) {
        Vec3 deltaMovement = entity.m_20184_();
        if (deltaMovement.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(deltaMovement.f_82479_, -deltaMovement.f_82480_ * (double)0.66f * d0, deltaMovement.f_82481_);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_CUSHION.isIn(blockState)) {
            return HitBoxes.NORDIC.cushion(this, blockState);
        }
        if (AllBlocks.DUNMER_CUSHION.isIn(blockState)) {
            return HitBoxes.DUNMER.cushion(this, blockState);
        }
        if (AllBlocks.VENTHYR_CUSHION.isIn(blockState)) {
            return HitBoxes.VENTHYR.cushion(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_SKULL.isIn(blockState) || AllBlocks.BONE_WITHER_SKULL.isIn(blockState)) {
            return HitBoxes.BONE.cushion(this, blockState);
        }
        if (AllBlocks.ROYAL_CUSHION.isIn(blockState)) {
            return HitBoxes.ROYAL.cushion(this, blockState);
        }
        if (AllBlocks.ROYAL_FLOOR_CUSHION.isIn(blockState)) {
            return ROYAL_FLOOR_CUSHION_SHAPER.get(BaseBlock.getFacing((BlockState)blockState));
        }
        if (AllBlocks.NECROLORD_CUSHION.isIn(blockState)) {
            return HitBoxes.NECROLORD.cushion(this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public static class Dyeable
    extends CushionBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MapColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MapColor defaultColor) {
            MapColor color = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, color);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }
}

