/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.tile;

import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.lmor.extrahnn.ExtraHostile;
import net.lmor.extrahnn.ExtraHostileConfig;
import net.lmor.extrahnn.api.ISettingCard;
import net.lmor.extrahnn.data.ExtraCachedModel;
import net.lmor.extrahnn.data.ExtraModelTier;
import net.lmor.extrahnn.item.ExtraDataModelItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class UltimateSimChamberTileEntity
extends BlockEntity
implements TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister,
ISettingCard {
    protected final SimItemHandler inventory = new SimItemHandler();
    protected final ModifiableEnergyStorage energy = new ModifiableEnergyStorage(ExtraHostileConfig.ultimateSimPowerCap, ExtraHostileConfig.ultimateSimPowerCap);
    protected final SimpleDataSlots data = new SimpleDataSlots();
    protected ExtraCachedModel currentModel = ExtraCachedModel.EMPTY;
    protected int runtime = 0;
    protected boolean predictionSuccess = false;
    protected FailureState failState = FailureState.NONE;
    private boolean checkOutput = true;

    public UltimateSimChamberTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExtraHostile.TileEntities.ULTIMATE_SIM_CHAMBER.get(), pos, state);
        this.data.addData(() -> this.runtime, v -> {
            this.runtime = v;
        });
        this.data.addData(() -> this.predictionSuccess, v -> {
            this.predictionSuccess = v;
        });
        this.data.addData(() -> this.failState.ordinal(), v -> {
            this.failState = FailureState.values()[v];
        });
        this.data.addEnergy(this.energy);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("energy", this.energy.getEnergyStored());
        tag.m_128405_("runtime", this.runtime);
        tag.m_128379_("predSuccess", this.predictionSuccess);
        tag.m_128405_("failState", this.failState.ordinal());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.energy.setEnergy(tag.m_128451_("energy"));
        ItemStack model = this.inventory.getStackInSlot(0);
        if (!model.m_41619_()) {
            this.currentModel = new ExtraCachedModel(model, 0);
        }
        this.runtime = tag.m_128451_("runtime");
        this.predictionSuccess = tag.m_128471_("predSuccess");
        this.failState = FailureState.values()[tag.m_128451_("failState")];
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.inventory.getStackInSlot(0).m_41619_()) {
            this.failState = FailureState.MODEL;
            this.runtime = 0;
            return;
        }
        if (this.inventory.getStackInSlot(1).m_41619_() && this.runtime == 0) {
            this.failState = FailureState.INPUT;
            return;
        }
        ItemStack model = this.inventory.getStackInSlot(0);
        if (!model.m_41619_()) {
            ExtraCachedModel oldModel = this.currentModel;
            this.currentModel = this.getOrLoadModel(model);
            if (oldModel != this.currentModel) {
                this.runtime = 0;
            }
            if (this.currentModel.isValid()) {
                if (this.runtime == 0) {
                    if (this.canStartSimulation()) {
                        this.runtime = ExtraHostileConfig.ultimateSimPowerDuration;
                        this.predictionSuccess = this.f_58857_.f_46441_.m_188501_() <= this.currentModel.getAccuracy();
                        this.inventory.getStackInSlot(1).m_41774_(4);
                        this.m_6596_();
                    }
                } else if (this.energy.getEnergyStored() >= this.currentModel.simCost()) {
                    this.failState = FailureState.NONE;
                    if (--this.runtime == 0) {
                        this.setResult(model);
                    } else {
                        this.energy.setEnergy(this.energy.getEnergyStored() - this.currentModel.simCost());
                        this.m_6596_();
                    }
                } else {
                    this.failState = FailureState.ENERGY_MID_CYCLE;
                }
                return;
            }
        }
        this.failState = FailureState.MODEL;
        this.runtime = 0;
    }

    public void setResult(ItemStack itemModel) {
        int newData;
        ExtraModelTier tier;
        ArrayList<ItemStack> predicateDrop = new ArrayList<ItemStack>();
        ArrayList<ItemStack> baseDrop = new ArrayList<ItemStack>();
        for (DynamicHolder<DataModel> model : this.currentModel.getModels()) {
            predicateDrop.add(((DataModel)model.get()).getPredictionDrop());
            baseDrop.add(((DataModel)model.get()).baseDrop());
        }
        this.setItem(baseDrop, 2, 6);
        if (this.predictionSuccess) {
            this.setItem(predicateDrop, 6, 10);
        }
        if ((tier = this.currentModel.getTier()) != tier.next() && (newData = this.currentModel.getData() + this.currentModel.getDataPerKill()) <= this.currentModel.getNextTierData()) {
            this.currentModel.setData(newData);
        }
        ExtraDataModelItem.setIters(itemModel, ExtraDataModelItem.getIters(itemModel) + 1);
        this.m_6596_();
    }

    public boolean canStartSimulation() {
        if (!this.checkOutput && this.failState == FailureState.OUTPUT) {
            return false;
        }
        if (this.inventory.getStackInSlot(1).m_41613_() < 4) {
            this.failState = FailureState.COUNT;
            return false;
        }
        if (this.energy.getEnergyStored() < this.currentModel.simCost()) {
            this.failState = FailureState.ENERGY;
            return false;
        }
        this.checkOutput = false;
        ItemStack[] baseDropSlots = new ItemStack[4];
        ItemStack[] basePredicateSlots = new ItemStack[4];
        for (int i = 2; i < 6; ++i) {
            baseDropSlots[i - 2] = this.inventory.getStackInSlot(i).m_41777_();
            basePredicateSlots[i - 2] = this.inventory.getStackInSlot(i + 4).m_41777_();
        }
        ArrayList<ItemStack> predicateDrop = new ArrayList<ItemStack>();
        ArrayList<ItemStack> baseDrop = new ArrayList<ItemStack>();
        for (DynamicHolder<DataModel> model : this.currentModel.getModels()) {
            predicateDrop.add(((DataModel)model.get()).getPredictionDrop());
            baseDrop.add(((DataModel)model.get()).baseDrop());
        }
        boolean dropSet = this.setItemEmulate(baseDropSlots, baseDrop);
        boolean predicateSet = this.setItemEmulate(basePredicateSlots, predicateDrop);
        if (predicateSet && dropSet) {
            this.failState = FailureState.NONE;
            return true;
        }
        this.failState = FailureState.OUTPUT;
        return false;
    }

    public boolean setItemEmulate(ItemStack[] slots, List<ItemStack> itemsToAdd) {
        for (ItemStack item : itemsToAdd) {
            int i;
            int remainingCount = item.m_41613_();
            for (i = 0; i < slots.length; ++i) {
                int spaceLeft;
                if (slots[i].m_41619_() || !this.canStack(slots[i], item) || (spaceLeft = slots[i].m_41741_() - slots[i].m_41613_()) <= 0) continue;
                int toAdd = Math.min(spaceLeft, remainingCount);
                slots[i].m_41769_(toAdd);
                if ((remainingCount -= toAdd) <= 0) break;
            }
            if (remainingCount > 0) {
                for (i = 0; i < slots.length; ++i) {
                    if (!slots[i].m_41619_()) continue;
                    int toPlace = Math.min(item.m_41741_(), remainingCount);
                    slots[i] = item.m_41777_();
                    if ((remainingCount -= toPlace) <= 0) break;
                }
            }
            if (remainingCount <= 0) continue;
            return false;
        }
        return true;
    }

    public void setItem(List<ItemStack> itemsToAdd, int startSlot, int endSlot) {
        block0: for (ItemStack item : itemsToAdd) {
            ItemStack slot;
            int i;
            int remainingCount = item.m_41613_();
            for (i = startSlot; i < endSlot; ++i) {
                int spaceLeft;
                slot = this.inventory.getStackInSlot(i);
                if (slot.m_41619_() || !this.canStack(slot, item) || (spaceLeft = slot.m_41741_() - slot.m_41613_()) <= 0) continue;
                int toAdd = Math.min(spaceLeft, remainingCount);
                slot.m_41769_(toAdd);
                if ((remainingCount -= toAdd) <= 0) break;
            }
            if (remainingCount <= 0) continue;
            for (i = startSlot; i < endSlot; ++i) {
                slot = this.inventory.getStackInSlot(i);
                if (!slot.m_41619_()) continue;
                int toPlace = Math.min(item.m_41741_(), remainingCount);
                ItemStack newItem = item.m_41777_();
                newItem.m_41764_(toPlace);
                this.inventory.setStackInSlot(i, newItem);
                if ((remainingCount -= toPlace) <= 0) continue block0;
            }
        }
    }

    public boolean canStack(ItemStack a, ItemStack b) {
        if (a.m_41619_()) {
            return true;
        }
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b) && a.m_41613_() < a.m_41741_();
    }

    protected ExtraCachedModel getOrLoadModel(ItemStack stack) {
        return this.currentModel.getSourceStack() == stack ? this.currentModel : new ExtraCachedModel(stack, 0);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return cap == ForgeCapabilities.ENERGY ? LazyOptional.of(() -> this.energy).cast() : super.getCapability(cap, side);
    }

    public SimItemHandler getInventory() {
        return this.inventory;
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public boolean didPredictionSucceed() {
        return this.predictionSuccess;
    }

    public FailureState getFailState() {
        return this.failState;
    }

    @Override
    public CompoundTag saveSetting() {
        CompoundTag tag = new CompoundTag();
        ItemStack item = this.inventory.getStackInSlot(0);
        if (!item.m_41619_()) {
            CompoundTag saveTag = new CompoundTag();
            item.m_41739_(saveTag);
            tag.m_128365_("dataModel", (Tag)saveTag);
        }
        tag.m_128359_("config", "UltimateSimChamberTileEntity");
        return tag;
    }

    @Override
    public boolean loadSetting(CompoundTag tag, Player player) {
        if (!tag.m_128441_("config") || !tag.m_128461_("config").equals("UltimateSimChamberTileEntity")) {
            return false;
        }
        if (!tag.m_128441_("dataModel")) {
            return false;
        }
        CompoundTag saveTag = tag.m_128469_("dataModel");
        Inventory playerInv = player.m_150109_();
        ItemStack item = ItemStack.m_41712_((CompoundTag)saveTag);
        int inventoryIndexItem = playerInv.m_36030_(item);
        ItemStack machineItem = this.inventory.getStackInSlot(0);
        if (machineItem == item) {
            return false;
        }
        if (!item.m_41619_() && inventoryIndexItem != -1) {
            playerInv.m_7407_(inventoryIndexItem, 1);
            if (!this.inventory.getStackInSlot(0).m_41619_()) {
                playerInv.m_36054_(this.inventory.getStackInSlot(0));
                this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            }
            this.inventory.setStackInSlot(0, item);
        }
        return true;
    }

    public class SimItemHandler
    extends InternalItemHandler {
        public SimItemHandler() {
            super(10);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.m_41720_() instanceof ExtraDataModelItem;
            }
            return slot != 1 || ExtraDataModelItem.matchesInput(this.getStackInSlot(0), stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot >= 2 ? stack : super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot <= 1 ? ItemStack.f_41583_ : super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            UltimateSimChamberTileEntity.this.checkOutput = true;
            UltimateSimChamberTileEntity.this.m_6596_();
        }
    }

    public static enum FailureState {
        NONE("hostilenetworks.fail.none"),
        OUTPUT("hostilenetworks.fail.output"),
        ENERGY("hostilenetworks.fail.energy"),
        INPUT("hostilenetworks.fail.input"),
        MODEL("hostilenetworks.fail.model"),
        ENERGY_MID_CYCLE("hostilenetworks.fail.energy_mid_cycle"),
        COUNT("extrahnn.fail.count");

        private final String id;

        private FailureState(String id) {
            this.id = id;
        }

        public String getKey() {
            return this.id;
        }
    }
}

