/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.tile;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import dev.shadowsoffire.placebo.recipe.VanillaPacketDispatcher;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import net.lmor.extrahnn.ExtraHostile;
import net.lmor.extrahnn.ExtraHostileConfig;
import net.lmor.extrahnn.api.ISettingCard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class UltimateLootFabTileEntity
extends BlockEntity
implements TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister,
ISettingCard {
    protected final FabItemHandler inventory = new FabItemHandler();
    protected final ModifiableEnergyStorage energy = new ModifiableEnergyStorage(ExtraHostileConfig.ultimateFabPowerCap, ExtraHostileConfig.ultimateFabPowerCap);
    protected final Object2IntMap<DynamicHolder<DataModel>> savedSelections = new Object2IntOpenHashMap();
    protected final SimpleDataSlots data = new SimpleDataSlots();
    protected int runtime = 0;
    protected int currentSel = -1;
    private boolean checkOutput = true;

    public UltimateLootFabTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExtraHostile.TileEntities.ULTIMATE_LOOT_FABRICATOR.get(), pos, state);
        this.savedSelections.defaultReturnValue(-1);
        this.data.addData(() -> this.runtime, v -> {
            this.runtime = v;
        });
        this.data.addEnergy(this.energy);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (!this.checkOutput) {
            return;
        }
        DynamicHolder dm = DataModelItem.getStoredModel((ItemStack)this.inventory.getStackInSlot(0));
        if (dm.isBound()) {
            int selection = this.getSelectedDrop((DataModel)dm.get());
            if (this.currentSel != selection) {
                this.currentSel = selection;
                this.runtime = 0;
                return;
            }
            if (selection != -1) {
                if (this.runtime >= ExtraHostileConfig.ultimateFabPowerDuration) {
                    if (this.checkOutput) {
                        this.checkOutput = false;
                        for (int i = 0; i < 4 && this.inventory.getStackInSlot(0).m_41613_() != 0; ++i) {
                            ItemStack out = ((ItemStack)((DataModel)dm.get()).fabDrops().get(selection)).m_41777_();
                            if (!this.insertInOutput(out, true)) continue;
                            this.runtime = 0;
                            this.insertInOutput(out, false);
                            this.inventory.getStackInSlot(0).m_41774_(1);
                            this.m_6596_();
                        }
                    }
                } else {
                    if (this.energy.getEnergyStored() < ExtraHostileConfig.ultimateFabPowerCost) {
                        return;
                    }
                    this.energy.setEnergy(this.energy.getEnergyStored() - ExtraHostileConfig.ultimateFabPowerCost);
                    ++this.runtime;
                    this.m_6596_();
                }
            } else {
                this.runtime = 0;
            }
        } else {
            this.runtime = 0;
        }
    }

    protected boolean insertInOutput(ItemStack stack, boolean sim) {
        for (int i = 1; i < 17; ++i) {
            if (!(stack = this.inventory.insertItemInternal(i, stack, sim)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public FabItemHandler getInventory() {
        return this.inventory;
    }

    public void setSelection(DynamicHolder<DataModel> model, int selection) {
        if (selection == -1) {
            this.savedSelections.removeInt(model);
        } else {
            this.savedSelections.put(model, Mth.m_14045_((int)selection, (int)0, (int)(((DataModel)model.get()).fabDrops().size() - 1)));
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        this.m_6596_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.energy).cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("energy", this.energy.getEnergyStored());
        tag.m_128405_("runtime", this.runtime);
        tag.m_128405_("selection", this.currentSel);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.readSelections(tag.m_128469_("saved_selections"));
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.energy.setEnergy(tag.m_128451_("energy"));
        this.runtime = tag.m_128451_("runtime");
        this.currentSel = tag.m_128451_("selection");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, t -> ((UltimateLootFabTileEntity)t).writeSync());
    }

    private CompoundTag writeSync() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.readSelections(pkt.m_131708_().m_128469_("saved_selections"));
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        return tag;
    }

    private CompoundTag writeSelections(CompoundTag tag) {
        for (Object2IntMap.Entry e : this.savedSelections.object2IntEntrySet()) {
            tag.m_128405_(((DynamicHolder)e.getKey()).getId().toString(), e.getIntValue());
        }
        return tag;
    }

    private void readSelections(CompoundTag tag) {
        this.savedSelections.clear();
        for (String s : tag.m_128431_()) {
            DynamicHolder dm = DataModelRegistry.INSTANCE.holder(new ResourceLocation(s));
            this.savedSelections.put((Object)dm, tag.m_128451_(s));
        }
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public int getSelectedDrop(DataModel model) {
        if (model == null) {
            return -1;
        }
        int index = this.savedSelections.getInt((Object)DataModelRegistry.INSTANCE.holder((CodecProvider)model));
        return index >= model.fabDrops().size() ? -1 : index;
    }

    @Override
    public CompoundTag saveSetting() {
        CompoundTag tag = new CompoundTag();
        CompoundTag saveTag = new CompoundTag();
        this.writeSelections(saveTag);
        tag.m_128365_("selections", (Tag)saveTag);
        return tag;
    }

    @Override
    public boolean loadSetting(CompoundTag tag, Player player) {
        if (!tag.m_128441_("selections")) {
            return false;
        }
        this.readSelections(tag.m_128469_("selections"));
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        this.m_6596_();
        return true;
    }

    public class FabItemHandler
    extends InternalItemHandler {
        public FabItemHandler() {
            super(17);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.m_41720_() == Hostile.Items.PREDICTION.get();
            }
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot > 0 ? stack : super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 0 ? ItemStack.f_41583_ : super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            UltimateLootFabTileEntity.this.checkOutput = true;
            UltimateLootFabTileEntity.this.m_6596_();
        }
    }
}

