/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.item;

import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.util.Color;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.tabs.ITabFiller;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.lmor.extrahnn.client.ExtraDataModelItemStackRenderer;
import net.lmor.extrahnn.data.ExtraCachedModel;
import net.lmor.extrahnn.data.ExtraModelTier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ExtraDataModelItem
extends Item
implements ITabFiller {
    public ExtraDataModelItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> list, TooltipFlag pFlag) {
        if (Screen.m_96638_()) {
            ExtraCachedModel model = new ExtraCachedModel(pStack, 0);
            if (!model.isValid()) {
                list.add((Component)Component.m_237110_((String)"Error: %s", (Object[])new Object[]{Component.m_237113_((String)"Broke_AF").m_130944_(new ChatFormatting[]{ChatFormatting.OBFUSCATED, ChatFormatting.GRAY})}));
                return;
            }
            int data = ExtraDataModelItem.getData(pStack);
            ExtraModelTier tier = model.getTier();
            list.add((Component)Component.m_237110_((String)"hostilenetworks.info.tier", (Object[])new Object[]{tier.getComponent()}));
            int progress = data - model.getTierData();
            int maxProgress = model.getNextTierData() - model.getTierData();
            if (tier != ExtraModelTier.OMNIPOTENT) {
                list.add((Component)Component.m_237110_((String)"hostilenetworks.info.data", (Object[])new Object[]{Component.m_237110_((String)"hostilenetworks.info.dprog", (Object[])new Object[]{progress, maxProgress}).m_130940_(ChatFormatting.GRAY)}));
                int dataPerKill = model.getDataPerKill();
                if (dataPerKill == 0) {
                    MutableComponent c1 = Component.m_237113_((String)"000 ").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.OBFUSCATED});
                    list.add((Component)Component.m_237110_((String)"hostilenetworks.info.dpk", (Object[])new Object[]{c1}).m_7220_((Component)Component.m_237115_((String)"hostilenetworks.info.disabled").m_130940_(ChatFormatting.RED)));
                } else {
                    list.add((Component)Component.m_237110_((String)"hostilenetworks.info.dpk", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(model.getDataPerKill())).m_130940_(ChatFormatting.GRAY)}));
                }
            }
            list.add((Component)Component.m_237110_((String)"hostilenetworks.info.sim_cost", (Object[])new Object[]{Component.m_237110_((String)"hostilenetworks.info.rft", (Object[])new Object[]{model.simCost()}).m_130940_(ChatFormatting.GRAY)}));
        } else {
            list.add((Component)Component.m_237110_((String)"hostilenetworks.info.hold_shift", (Object[])new Object[]{Color.withColor((String)"hostilenetworks.color_text.shift", (int)ChatFormatting.WHITE.m_126665_())}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void fillItemCategory(CreativeModeTab tab, CreativeModeTab.Output output) {
        ArrayList<ResourceLocation> resourceLocationsList = new ArrayList<ResourceLocation>();
        ItemStack item = new ItemStack((ItemLike)this);
        DataModelRegistry.INSTANCE.getKeys().stream().sorted().forEach(key -> {
            resourceLocationsList.add((ResourceLocation)key);
            output.m_246342_(item);
        });
        ExtraDataModelItem.setStoredResources(item, resourceLocationsList);
    }

    public Component m_7626_(ItemStack pStack) {
        List<DynamicHolder<DataModel>> models = ExtraDataModelItem.getStoredModels(pStack);
        ArrayList<Object> modelName = new ArrayList<MutableComponent>();
        for (DynamicHolder<DataModel> model : models) {
            if (!model.isBound()) {
                modelName = new ArrayList<MutableComponent>(List.of(Component.m_237113_((String)"BROKEN").m_130940_(ChatFormatting.OBFUSCATED)));
                break;
            }
            modelName.add(((DataModel)model.get()).name());
        }
        if (modelName.size() == 1) {
            return Component.m_237110_((String)"item.extrahnn.extra_data_model.broken", (Object[])new Object[]{modelName.get(0)});
        }
        return Component.m_237110_((String)this.m_5671_(pStack), (Object[])new Object[]{modelName.get(0), modelName.get(1), modelName.get(2), modelName.get(3)});
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            ExtraDataModelItemStackRenderer dmisr = new ExtraDataModelItemStackRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.dmisr;
            }
        });
    }

    public static List<DynamicHolder<DataModel>> getStoredModels(ItemStack stack) {
        DynamicHolder emptyHolder = DataModelRegistry.INSTANCE.emptyHolder();
        ArrayList<Object> holders = new ArrayList<DynamicHolder<DataModel>>(List.of(emptyHolder, emptyHolder, emptyHolder, emptyHolder));
        if (stack.m_41619_()) {
            return holders;
        }
        CompoundTag dataModelTag = stack.m_41737_("data_model");
        if (dataModelTag == null) {
            return holders;
        }
        ListTag idList = dataModelTag.m_128437_("ids", 8);
        holders = new ArrayList();
        for (int i = 0; i < idList.size(); ++i) {
            String id = idList.m_128778_(i);
            holders.add((DynamicHolder<DataModel>)DataModelRegistry.INSTANCE.holder(new ResourceLocation(id)));
        }
        return holders;
    }

    public static void setStoredModels(ItemStack stack, List<DataModel> models) {
        ArrayList<ResourceLocation> resourceLocationsList = new ArrayList<ResourceLocation>();
        for (DataModel model : models) {
            resourceLocationsList.add(DataModelRegistry.INSTANCE.getKey((CodecProvider)model));
        }
        ExtraDataModelItem.setStoredResources(stack, resourceLocationsList);
    }

    public static void setStoredResources(ItemStack stack, List<ResourceLocation> models) {
        stack.m_41749_("data_model");
        CompoundTag dataModelTag = stack.m_41698_("data_model");
        ListTag idList = dataModelTag.m_128437_("models", 8);
        for (ResourceLocation model : models) {
            idList.add((Object)StringTag.m_129297_((String)model.toString()));
        }
        stack.m_41698_("data_model").m_128365_("ids", (Tag)idList);
    }

    public static int getData(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("data_model");
        return !stack.m_41619_() && tag != null ? tag.m_128451_("data") : 0;
    }

    public static void setData(ItemStack stack, int data) {
        stack.m_41698_("data_model").m_128405_("data", data);
    }

    public static int getIters(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("data_model");
        return !stack.m_41619_() && tag != null ? tag.m_128451_("iterations") : 0;
    }

    public static void setIters(ItemStack stack, int data) {
        stack.m_41698_("data_model").m_128405_("iterations", data);
    }

    public static boolean matchesInput(ItemStack model, ItemStack stack) {
        List<DynamicHolder<DataModel>> models = ExtraDataModelItem.getStoredModels(model);
        for (DynamicHolder<DataModel> dm : models) {
            boolean inputItem;
            if (!dm.isBound()) {
                return false;
            }
            ItemStack input = ((DataModel)dm.get()).input();
            boolean bl = inputItem = input.m_41720_() == stack.m_41720_();
            if (input.m_41782_()) {
                String s;
                if (!stack.m_41782_()) continue;
                CompoundTag tag1 = input.m_41783_();
                CompoundTag tag2 = stack.m_41783_();
                Iterator iterator = tag1.m_128431_().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return true;
                } while (tag1.m_128423_(s = (String)iterator.next()).equals(tag2.m_128423_(s)));
                continue;
            }
            if (!inputItem) continue;
            return true;
        }
        return false;
    }
}

