/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.gui;

import dev.shadowsoffire.hostilenetworks.data.CachedModel;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import dev.shadowsoffire.placebo.screen.TickableText;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.lmor.extrahnn.ExtraHostileConfig;
import net.lmor.extrahnn.ExtraHostileNetworks;
import net.lmor.extrahnn.data.ExtraCachedModel;
import net.lmor.extrahnn.data.ExtraModelTier;
import net.lmor.extrahnn.gui.UltimateSimChamberContainer;
import net.lmor.extrahnn.tile.UltimateSimChamberTileEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class UltimateSimChamberScreen
extends PlaceboContainerScreen<UltimateSimChamberContainer> {
    public static final int WIDTH = 232;
    public static final int HEIGHT = 256;
    private static final ResourceLocation BASE = ExtraHostileNetworks.local("textures/gui/ultimate_sim_chamber.png");
    private static final ResourceLocation PLAYER = ExtraHostileNetworks.local("textures/gui/inventory.png");
    private final List<TickableText> body = new ArrayList<TickableText>(7);
    private UltimateSimChamberTileEntity.FailureState lastFailState = UltimateSimChamberTileEntity.FailureState.NONE;
    private boolean runtimeTextLoaded = false;
    private static final Component ERROR = Component.m_237113_((String)"ERROR").m_130940_(ChatFormatting.OBFUSCATED);

    public UltimateSimChamberScreen(UltimateSimChamberContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 232;
        this.f_97727_ = 256;
    }

    protected void m_280072_(GuiGraphics gfx, int pX, int pY) {
        if (this.m_6774_(211, 73, 7, 87, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(2);
            txt.add(Component.m_237110_((String)"hostilenetworks.gui.energy", (Object[])new Object[]{((UltimateSimChamberContainer)this.f_97732_).getEnergyStored(), ExtraHostileConfig.ultimateSimPowerCap}));
            ExtraCachedModel cModel = new ExtraCachedModel(((UltimateSimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
            if (cModel.isValid()) {
                txt.add(Component.m_237110_((String)"hostilenetworks.gui.cost", (Object[])new Object[]{cModel.simCost()}));
            }
            gfx.m_280666_(this.f_96547_, txt, pX, pY);
        } else if (this.m_6774_(14, 73, 7, 87, pX, pY)) {
            ExtraCachedModel cModel = new ExtraCachedModel(((UltimateSimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
            if (cModel.isValid()) {
                ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(1);
                if (cModel.getTier() != cModel.getTier().next()) {
                    txt.add(Component.m_237110_((String)"hostilenetworks.gui.data", (Object[])new Object[]{cModel.getData() - cModel.getTierData(), cModel.getNextTierData() - cModel.getTierData()}));
                } else {
                    txt.add(Component.m_237115_((String)"hostilenetworks.gui.max_data").m_130940_(ChatFormatting.RED));
                }
                gfx.m_280666_(this.f_96547_, txt, pX, pY);
            }
        } else if (((UltimateSimChamberContainer)this.f_97732_).m_38853_(0).m_7993_().m_41619_() && this.m_6774_(-13, 1, 16, 16, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(1);
            txt.add(Component.m_237115_((String)"extrahnn.info.data_model_slot"));
            gfx.m_280666_(this.f_96547_, txt, pX, pY);
        } else {
            super.m_280072_(gfx, pX, pY);
        }
    }

    protected void m_280003_(GuiGraphics gfx, int pX, int pY) {
        int spacing;
        int top;
        int left;
        int runtime = ((UltimateSimChamberContainer)this.f_97732_).getRuntime();
        if (runtime > 0) {
            int rTime = Math.min(99, Mth.m_14167_((float)(100.0f * (float)(ExtraHostileConfig.ultimateSimPowerDuration - runtime) / (float)ExtraHostileConfig.ultimateSimPowerDuration)));
            gfx.m_280056_(this.f_96547_, rTime + "%", 186, 150, 6478079, true);
        }
        ExtraCachedModel cModel = new ExtraCachedModel(((UltimateSimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_85841_(0.7f, 0.7f, 0.7f);
        if (cModel.isValid()) {
            left = 25;
            top = 9;
            spacing = 4;
            String msg = I18n.m_118938_((String)"extrahnn.gui.targets", (Object[])new Object[0]);
            gfx.m_280488_(this.f_96547_, msg, left, top, 0xFFFFFF);
            top = top + 9 + spacing;
            for (int i = 0; i < cModel.getModels().size(); ++i) {
                float scale = this.f_96547_.m_92852_((FormattedText)((DataModel)cModel.getModels().get(i).get()).name()) <= 139 ? 1.0f : 139.0f / (float)this.f_96547_.m_92852_((FormattedText)((DataModel)cModel.getModels().get(i).get()).name());
                gfx.m_280168_().m_85836_();
                gfx.m_280168_().m_85841_(scale, scale, scale);
                gfx.m_280488_(this.f_96547_, " - ", left - 2, top + (9 + spacing) * i, 65472);
                gfx.m_280430_(this.f_96547_, (Component)((DataModel)cModel.getModels().get(i).get()).name(), left + 13, top + (9 + spacing) * i, 65472);
                gfx.m_280168_().m_85849_();
            }
            msg = I18n.m_118938_((String)"hostilenetworks.gui.tier", (Object[])new Object[0]);
            gfx.m_280488_(this.f_96547_, msg, left, top += (9 + spacing) * 4, 0xFFFFFF);
            gfx.m_280488_(this.f_96547_, I18n.m_118938_((String)("extrahnn.tier." + cModel.getTier().name), (Object[])new Object[0]), left + this.f_96547_.m_92895_(msg), top, cModel.getTier().color());
            top = top + 9 + spacing;
            msg = I18n.m_118938_((String)"hostilenetworks.gui.accuracy", (Object[])new Object[0]);
            gfx.m_280488_(this.f_96547_, msg, left, top, 0xFFFFFF);
            DecimalFormat fmt = new DecimalFormat("##.##%");
            gfx.m_280488_(this.f_96547_, fmt.format(cModel.getAccuracy()), left + this.f_96547_.m_92895_(msg), top, cModel.getTier().color());
        }
        gfx.m_280168_().m_85849_();
        left = 29;
        top = 77;
        Objects.requireNonNull(this.f_96547_);
        spacing = 12;
        int idx = 0;
        for (TickableText t : this.body) {
            t.render(this.f_96547_, gfx, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 29;
                continue;
            }
            left += t.getWidth(this.f_96547_);
        }
    }

    protected void m_7286_(GuiGraphics gfx, float pPartialTicks, int pX, int pY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        gfx.m_280163_(BASE, left + 8, top, 0.0f, 0.0f, 216, 166, 256, 256);
        gfx.m_280163_(BASE, left - 14, top, 216.0f, 0.0f, 18, 18, 256, 256);
        int energyHeight = 87 - Mth.m_14167_((float)(87.0f * (float)((UltimateSimChamberContainer)this.f_97732_).getEnergyStored() / (float)ExtraHostileConfig.ultimateSimPowerCap));
        gfx.m_280163_(BASE, left + 211, top + 73, 234.0f, 0.0f, 7, energyHeight, 256, 256);
        int dataHeight = 87;
        ExtraCachedModel cModel = new ExtraCachedModel(((UltimateSimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
        if (cModel.isValid()) {
            ExtraModelTier next;
            int data = cModel.getData();
            ExtraModelTier tier = cModel.getTier();
            dataHeight = tier == (next = tier.next()) ? 0 : 87 - Mth.m_14167_((float)(87.0f * (float)(data - cModel.getTierData()) / (float)(cModel.getNextTierData() - cModel.getTierData())));
        }
        gfx.m_280163_(BASE, left + 14, top + 73, 234.0f, 0.0f, 7, dataHeight, 256, 256);
        gfx.m_280163_(PLAYER, left + 28, top + 167, 0.0f, 0.0f, 176, 90, 256, 256);
    }

    public void m_181908_() {
        if (((UltimateSimChamberContainer)this.f_97732_).getFailState() != UltimateSimChamberTileEntity.FailureState.NONE) {
            UltimateSimChamberTileEntity.FailureState oState = this.lastFailState;
            this.lastFailState = ((UltimateSimChamberContainer)this.f_97732_).getFailState();
            if (oState != this.lastFailState) {
                this.body.clear();
                String[] msg = I18n.m_118938_((String)this.lastFailState.getKey(), (Object[])new Object[0]).split("\\n");
                if (this.lastFailState == UltimateSimChamberTileEntity.FailureState.INPUT) {
                    CachedModel cModel = new CachedModel(((UltimateSimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
                    MutableComponent name = Component.m_237115_((String)"item.hostilenetworks.prediction_matrix");
                    if (cModel.isValid()) {
                        name = cModel.getModel().input().m_41786_();
                    }
                    msg = I18n.m_118938_((String)this.lastFailState.getKey(), (Object[])new Object[]{name.getString()}).split("\\n");
                }
                String[] msg1 = msg;
                int i = msg.length;
                for (int j = 0; j < i; ++j) {
                    String key = msg1[j];
                    this.body.add(new TickableText(key, 0xFFFFFF));
                }
            }
            this.runtimeTextLoaded = false;
        } else if (!this.runtimeTextLoaded) {
            int ticks = ExtraHostileConfig.ultimateSimPowerDuration - ((UltimateSimChamberContainer)this.f_97732_).getRuntime();
            float speed = 1.3f;
            this.body.clear();
            int iters = DataModelItem.getIters((ItemStack)((UltimateSimChamberContainer)this.f_97732_).m_38853_(0).m_7993_());
            for (int i = 0; i < 7; ++i) {
                TickableText txt = new TickableText(I18n.m_118938_((String)("hostilenetworks.run." + i), (Object[])new Object[]{iters}), 0xFFFFFF, i != 0 && i != 5, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                if (i == 0) {
                    txt = new TickableText("v" + ExtraHostileNetworks.VERSION, ChatFormatting.GOLD.m_126665_().intValue(), true, speed);
                    this.body.add(txt.setTicks(ticks));
                    ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                    continue;
                }
                if (i != 5) continue;
                String s = ((UltimateSimChamberContainer)this.f_97732_).didPredictionSucceed() ? "success" : "failed";
                String key = "hostilenetworks.color_text." + s;
                txt = new TickableText(I18n.m_118938_((String)key, (Object[])new Object[0]), (((UltimateSimChamberContainer)this.f_97732_).didPredictionSucceed() ? ChatFormatting.GOLD : ChatFormatting.RED).m_126665_().intValue(), true, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
            }
            this.runtimeTextLoaded = true;
            this.lastFailState = UltimateSimChamberTileEntity.FailureState.NONE;
        }
        TickableText.tickList(this.body);
        if (((UltimateSimChamberContainer)this.f_97732_).getRuntime() == 0) {
            this.runtimeTextLoaded = false;
        }
    }
}

