/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.extrahnn.data;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.StringRepresentable;

public enum ExtraModelTier implements StringRepresentable
{
    AUTONOMOUS("autonomous", 0, 20, ChatFormatting.AQUA, 0.1f),
    INTELLIGENT("intelligent", 1500, 30, ChatFormatting.DARK_AQUA, 0.3f),
    ADAPTIVE("adaptive", 4500, 50, ChatFormatting.RED, 0.5f),
    SYNTHETIC("synthetic", 10750, 75, ChatFormatting.DARK_RED, 0.74f),
    OMNIPOTENT("omnipotent", 22375, 0, ChatFormatting.DARK_PURPLE, 1.0f);

    private static final ExtraModelTier[] VALUES;
    public final String name;
    private TierData tierData;
    private int requiredData;
    public static final Codec<ExtraModelTier> CODEC;

    private ExtraModelTier(String name, int requiredData, int dataPerKill, ChatFormatting color, float accuracy) {
        this(name, requiredData, dataPerKill, TextColor.m_131270_((ChatFormatting)color), accuracy);
    }

    private ExtraModelTier(String name, int requiredData, int dataPerKill, TextColor color, float accuracy) {
        this.name = name;
        this.tierData = new TierData(requiredData, dataPerKill, color, accuracy);
        this.requiredData = requiredData;
    }

    public ExtraModelTier previous() {
        return this == AUTONOMOUS ? this : VALUES[this.ordinal() - 1];
    }

    public ExtraModelTier next() {
        return this == OMNIPOTENT ? this : VALUES[this.ordinal() + 1];
    }

    public Component getComponent() {
        return Component.m_237115_((String)("extrahnn.tier." + this.name)).m_130948_(Style.f_131099_.m_131148_(this.data().color));
    }

    public static ExtraModelTier getByData(int data) {
        for (int i = 4; i >= 0; --i) {
            if (data < ExtraModelTier.VALUES[i].requiredData) continue;
            return VALUES[i];
        }
        return AUTONOMOUS;
    }

    public static int[] defaultData() {
        return Arrays.stream(VALUES).mapToInt(t -> t.data().requiredData).toArray();
    }

    public static int[] defaultDataPerKill() {
        return Arrays.stream(VALUES).mapToInt(t -> t.data().dataPerKill).toArray();
    }

    public String m_7912_() {
        return this.name;
    }

    public TierData data() {
        return this.tierData;
    }

    public int color() {
        return this.data().color.m_131265_();
    }

    public float accuracy() {
        return this.data().accuracy;
    }

    void updateData(TierData data) {
        this.tierData = data;
    }

    static {
        VALUES = ExtraModelTier.values();
        CODEC = StringRepresentable.m_216439_(() -> VALUES);
    }

    public record TierData(int requiredData, int dataPerKill, TextColor color, float accuracy) {
    }
}

