/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientStack(Ingredient ingredient, int count) {
    public static final IngredientStack EMPTY = new IngredientStack(Ingredient.f_43901_, 1);

    public boolean test(ItemStack itemStack) {
        return itemStack.m_41613_() >= this.count && this.ingredient.test(itemStack);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("ingredient", this.ingredient.m_43942_());
        json.addProperty("count", (Number)this.count);
        return json;
    }

    public static IngredientStack fromJson(JsonObject jsonObject) {
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonObject.get("ingredient"));
        int count = jsonObject.get("count").getAsInt();
        return new IngredientStack(ingredient, count);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        this.ingredient.m_43923_(buf);
        buf.writeInt(this.count);
    }

    public static IngredientStack fromNetwork(FriendlyByteBuf buf) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int count = buf.readInt();
        return new IngredientStack(ingredient, count);
    }
}

