/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.permutated.exmachinis.recipes.CompactingRecipe;

public class CompactingRegistry {
    private final Object lock = new Object();
    private List<CompactingRecipe> recipeList = Collections.emptyList();
    private final Map<Item, CompactingRecipe> recipeByItemCache = new ConcurrentHashMap<Item, CompactingRecipe>();

    public CompactingRecipe findRecipe(Item item) {
        return this.recipeByItemCache.computeIfAbsent(item, it -> {
            ItemStack itemStack = new ItemStack((ItemLike)it);
            return this.recipeList.stream().filter(recipe -> recipe.getIngredient().ingredient().test(itemStack)).findFirst().orElse(CompactingRecipe.EMPTY);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecipeList(List<CompactingRecipe> recipes) {
        Object object = this.lock;
        synchronized (object) {
            this.recipeList = List.copyOf(recipes);
            this.recipeByItemCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CompactingRecipe> getRecipeList() {
        Object object = this.lock;
        synchronized (object) {
            return this.recipeList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecipes() {
        Object object = this.lock;
        synchronized (object) {
            this.recipeList = Collections.emptyList();
            this.recipeByItemCache.clear();
        }
    }
}

