/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.machines.hammer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.hammer.FluxHammerBlock;
import net.permutated.exmachinis.util.ItemStackUtil;
import net.permutated.exmachinis.util.WorkStatus;

public class FluxHammerTile
extends AbstractMachineTile {
    public FluxHammerTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FLUX_HAMMER_TILE.get(), pos, state);
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return true;
    }

    private void migrate(ServerLevel serverLevel) {
        if (this.version == 1) {
            return;
        }
        if (this.version > 1) {
            ExMachinis.LOGGER.error("Current tile version higher than block version - things may break!");
            return;
        }
        if (this.version == 0) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)FluxHammerBlock.FACING);
            serverLevel.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)AbstractMachineBlock.OUTPUT, (Comparable)facing), 2);
            this.version = 1;
            this.m_6596_();
        }
    }

    @Override
    public void tick() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(this.getUpgradeTickDelay())) {
                int quotient;
                this.migrate(serverLevel);
                Boolean enabled = (Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.ENABLED);
                if (Boolean.FALSE.equals(enabled)) {
                    this.workStatus = WorkStatus.REDSTONE_DISABLED;
                    return;
                }
                Direction output = (Direction)this.m_58900_().m_61143_((Property)AbstractMachineBlock.OUTPUT);
                BlockPos outPos = this.m_58899_().m_121945_(output);
                BlockEntity target = this.f_58857_.m_7702_(outPos);
                if (target == null) {
                    this.workStatus = WorkStatus.MISSING_INVENTORY;
                    return;
                }
                IItemHandler itemHandler = target.getCapability(ForgeCapabilities.ITEM_HANDLER, output.m_122424_()).resolve().orElse(null);
                if (itemHandler == null || itemHandler.getSlots() == 0) {
                    this.workStatus = WorkStatus.MISSING_INVENTORY;
                    return;
                }
                this.workStatus = WorkStatus.WORKING;
                int cost = this.getUpgradeEnergyCost();
                int stored = this.energyStorage.getEnergyStored();
                int maxProcessed = this.getUpgradeItemsProcessed();
                if (stored < cost) {
                    this.workStatus = WorkStatus.OUT_OF_ENERGY;
                    return;
                }
                if (cost > 0 && (quotient = stored / cost) < maxProcessed) {
                    maxProcessed = quotient;
                }
                for (int i = 0; i < this.itemStackHandler.getSlots() && maxProcessed != 0; ++i) {
                    int multiplier;
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (stack.m_41619_() || !ExNihiloAPI.canHammer(stack)) continue;
                    ItemStack copy = stack.m_41777_();
                    int count = stack.m_41613_();
                    if (count >= maxProcessed) {
                        multiplier = maxProcessed;
                        copy.m_41774_(maxProcessed);
                        maxProcessed = 0;
                    } else {
                        multiplier = count;
                        copy = ItemStack.f_41583_;
                        maxProcessed -= count;
                    }
                    if (!this.processResults(serverLevel, itemHandler, stack, multiplier, true)) {
                        return;
                    }
                    int totalCost = cost * multiplier;
                    boolean result = this.energyStorage.consumeEnergy(totalCost, true);
                    if (!result) {
                        this.workStatus = WorkStatus.OUT_OF_ENERGY;
                        return;
                    }
                    this.itemStackHandler.setStackInSlot(i, copy);
                    this.energyStorage.consumeEnergy(totalCost, false);
                    this.processResults(serverLevel, itemHandler, stack, multiplier, false);
                }
                this.pullFromAbove();
            }
        }
    }

    private boolean processResults(ServerLevel serverLevel, IItemHandler itemHandler, ItemStack stack, int multiplier, boolean simulate) {
        ExNihiloAPI.getHammerResult(serverLevel, stack).stream().map(result -> ItemStackUtil.multiplyStackCount(result, multiplier)).map(output -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)output, (boolean)simulate)).forEach(response -> {
            if (!response.m_41619_()) {
                this.workStatus = WorkStatus.INVENTORY_FULL;
            }
        });
        return this.workStatus == WorkStatus.WORKING;
    }

    private void pullFromAbove() {
        BlockPos above;
        BlockEntity targetAbove;
        IItemHandler inputItemHandler = null;
        if (this.f_58857_ != null && ((Boolean)this.m_58900_().m_61143_((Property)FluxHammerBlock.HOPPER)).equals(Boolean.TRUE) && (targetAbove = this.f_58857_.m_7702_(above = this.m_58899_().m_7494_())) != null) {
            inputItemHandler = targetAbove.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).resolve().orElse(null);
        }
        if (inputItemHandler != null) {
            for (int i = 0; i < inputItemHandler.getSlots(); ++i) {
                ItemStack stack = inputItemHandler.getStackInSlot(i);
                if (stack.m_41619_() || !ExNihiloAPI.canHammer(stack)) continue;
                ItemStack extractResult = inputItemHandler.extractItem(i, stack.m_41741_(), true);
                ItemStack insertResult = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemStackHandler, (ItemStack)extractResult, (boolean)true);
                if (extractResult.m_41613_() <= insertResult.m_41613_()) continue;
                int inserted = extractResult.m_41613_() - insertResult.m_41613_();
                ItemStack extracted = inputItemHandler.extractItem(i, inserted, false);
                ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemStackHandler, (ItemStack)extracted, (boolean)false);
                return;
            }
        }
    }
}

