/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis.events;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.permutated.exmachinis.ExMachinis;
import net.permutated.exmachinis.ModRegistry;
import net.permutated.exmachinis.compat.exnihilo.ExNihiloAPI;
import net.permutated.exmachinis.machines.base.AbstractMachineBlock;

@Mod.EventBusSubscriber(modid="exmachinis", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    private ForgeEventHandler() {
    }

    public static void loadCompactingRecipes(RecipeManager recipeManager) {
        List compactingRecipes = recipeManager.m_44013_((RecipeType)ModRegistry.COMPACTING_RECIPE_TYPE.get());
        ModRegistry.COMPACTING_REGISTRY.setRecipeList(compactingRecipes);
        ExMachinis.LOGGER.debug("Registered {} compacting recipes", (Object)compactingRecipes.size());
    }

    @SubscribeEvent
    public static void onRecipesUpdatedEvent(RecipesUpdatedEvent event) {
        ExMachinis.LOGGER.debug("Loading recipes on server sync");
        ForgeEventHandler.loadCompactingRecipes(event.getRecipeManager());
    }

    @SubscribeEvent
    public static void onServerStartingEvent(ServerStartingEvent event) {
        if (event.getServer().m_6982_()) {
            ExMachinis.LOGGER.debug("Loading recipes on server startup");
            ForgeEventHandler.loadCompactingRecipes(event.getServer().m_129894_());
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            BlockState blockState;
            ServerLevel level2 = (ServerLevel)level;
            if (event.getEntity().m_6144_() && ExNihiloAPI.isHammerItem(event.getItemStack()) && (blockState = level2.m_8055_(event.getPos())).m_60734_() instanceof AbstractMachineBlock) {
                Direction facing = event.getHitVec().m_82434_();
                Direction output = (Direction)blockState.m_61143_((Property)AbstractMachineBlock.OUTPUT);
                event.setUseBlock(Event.Result.DENY);
                if (!facing.equals((Object)output)) {
                    level2.m_7731_(event.getPos(), (BlockState)blockState.m_61124_((Property)AbstractMachineBlock.OUTPUT, (Comparable)facing), 2);
                }
            }
        }
    }
}

