/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.network.NetworkHandler;

public abstract class AbstractMachineMenu<M extends AbstractMachineBlockEntity<M>>
extends AbstractContainerMenu {
    protected static final int PLAYER_SLOTS = 36;
    @Nullable
    private final ServerPlayer player;
    public final M machine;
    public int prevEnergy;

    protected AbstractMachineMenu(MenuType<?> pMenuType, int pContainerId, Inventory playerInventory, M machine) {
        super(pMenuType, pContainerId);
        ServerPlayer serverPlayer;
        this.machine = machine;
        Player player = playerInventory.f_35978_;
        this.player = player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null;
    }

    protected static <M extends AbstractMachineBlockEntity<M>> M readPayload(Inventory playerInventory, FriendlyByteBuf data) {
        AbstractMachineBlockEntity machine = (AbstractMachineBlockEntity)playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        machine.setRedstoneMode(data.readByte());
        return (M)((Object)machine);
    }

    protected final void addPlayerSlots(Inventory playerInventory, int startY) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, startY + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, startY + 58));
        }
    }

    public void setClientProperty(int index, int value) {
        if (index == 0) {
            this.prevEnergy = value;
        }
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.player != null) {
            this.syncProperties(this.player);
        }
    }

    public void m_182423_() {
        super.m_182423_();
        if (this.player != null) {
            this.syncProperties(this.player);
        }
    }

    protected void syncProperties(ServerPlayer player) {
        if (this.prevEnergy != ((AbstractMachineBlockEntity)((Object)this.machine)).energy.getEnergyStored()) {
            this.prevEnergy = ((AbstractMachineBlockEntity)((Object)this.machine)).energy.getEnergyStored();
            NetworkHandler.sendMenuProperty(player, this.f_38840_, 0, this.prevEnergy);
        }
    }

    public boolean m_6366_(Player pPlayer, int id) {
        if (0 <= id && id < 3) {
            ((AbstractMachineBlockEntity)((Object)this.machine)).setRedstoneMode(id);
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return ((AbstractMachineBlockEntity)((Object)this.machine)).stillValid(player);
    }
}

