/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EItems;

public class PorcelainBucket
extends Item {
    private final Supplier<? extends Fluid> fluid;

    public PorcelainBucket(Supplier<? extends Fluid> fluid, Item.Properties properties) {
        super(properties);
        this.fluid = fluid;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof Cow && !target.m_6162_()) {
            Level level = player.m_9236_();
            player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            if (!level.f_46443_) {
                ItemStack result = ItemUtils.m_41813_((ItemStack)(stack.m_41613_() == 1 ? stack.m_41777_() : stack), (Player)player, (ItemStack)new ItemStack((ItemLike)EItems.PORCELAIN_MILK_BUCKET.get()));
                player.m_21008_(hand, result);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        BlockHitResult hitResult;
        ItemStack stack = player.m_21120_(pHand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)stack, (HitResult)(hitResult = PorcelainBucket.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.fluid.get() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (ret != null) {
            return ret;
        }
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = hitResult.m_82425_();
        Direction face = hitResult.m_82434_();
        BlockPos relative = pos.m_121945_(face);
        if (level.m_7966_(player, pos) && player.m_36204_(relative, face, stack)) {
            BlockPos placePos;
            if (this.fluid.get() == Fluids.f_76191_) {
                Block block;
                BlockState state = level.m_8055_(pos);
                FluidType fluidType = state.m_60819_().getFluidType();
                if ((fluidType == ForgeMod.WATER_TYPE.get() || fluidType == ForgeMod.LAVA_TYPE.get() || fluidType == EFluids.WITCH_WATER_TYPE.get()) && (block = state.m_60734_()) instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    ItemStack result = pickup.m_142598_((LevelAccessor)level, pos, state);
                    result = fluidType == ForgeMod.WATER_TYPE.get() ? new ItemStack((ItemLike)EItems.PORCELAIN_WATER_BUCKET.get()) : (fluidType == ForgeMod.LAVA_TYPE.get() ? new ItemStack((ItemLike)EItems.PORCELAIN_LAVA_BUCKET.get()) : new ItemStack((ItemLike)EItems.PORCELAIN_WITCH_WATER_BUCKET.get()));
                    if (!result.m_41619_()) {
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        pickup.getPickupSound(state).ifPresent(sound -> player.m_5496_(sound, 1.0f, 1.0f));
                        level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
                        ItemStack filled = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)result);
                        if (!level.f_46443_) {
                            CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, result);
                        }
                        return InteractionResultHolder.m_19092_((Object)filled, (boolean)level.m_5776_());
                    }
                }
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            BlockState state = level.m_8055_(pos);
            BlockPos blockPos = placePos = this.canBlockContainFluid(level, pos, state) ? pos : relative;
            if (this.emptyContents(player, level, placePos, hitResult, stack)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10591_.m_285767_(serverPlayer, placePos, stack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)this.getEmptySuccessItem(stack, player), (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        if (!player.m_150110_().f_35937_) {
            if (this.fluid.get() == Fluids.f_76195_) {
                return ItemStack.f_41583_;
            }
            return new ItemStack((ItemLike)EItems.PORCELAIN_BUCKET.get());
        }
        return stack;
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult hitResult, @Nullable ItemStack container) {
        LiquidBlockContainer liquidContainer;
        LiquidBlockContainer liquidContainer2;
        if (!(this.fluid.get() instanceof FlowingFluid)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        boolean replacing = state.m_60722_(this.fluid.get());
        boolean canPlaceAtPos = state.m_60795_() || replacing || block instanceof LiquidBlockContainer && (liquidContainer2 = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.fluid.get());
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        if (!canPlaceAtPos) {
            return hitResult != null && this.emptyContents(player, level, hitResult.m_82425_().m_121945_(hitResult.m_82434_()), null, container);
        }
        if (containedFluidStack.isPresent() && this.fluid.get().getFluidType().isVaporizedOnPlacement(level, pos, (FluidStack)containedFluidStack.get())) {
            this.fluid.get().getFluidType().onVaporize(player, level, pos, (FluidStack)containedFluidStack.get());
            return true;
        }
        if (level.m_6042_().f_63857_() && this.fluid.get().m_205067_(FluidTags.f_13131_)) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && (liquidContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.fluid.get())) {
            liquidContainer.m_7361_((LevelAccessor)level, pos, state, ((FlowingFluid)this.fluid.get()).m_76068_(false));
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.f_46443_ && replacing && !state.m_278721_()) {
            level.m_46961_(pos, true);
        }
        if (!level.m_7731_(pos, this.fluid.get().m_76145_().m_76188_(), 11) && !state.m_60819_().m_76170_()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }

    protected void playEmptySound(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos) {
        SoundEvent sound = this.fluid.get().getFluidType().getSound(pPlayer, (BlockGetter)pLevel, pPos, SoundActions.BUCKET_EMPTY);
        if (sound == null) {
            sound = this.fluid.get().m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        pLevel.m_5594_(pPlayer, pPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157769_, pPos);
    }

    protected boolean canBlockContainFluid(Level level, BlockPos pos, BlockState state) {
        LiquidBlockContainer block;
        Block block2 = state.m_60734_();
        return block2 instanceof LiquidBlockContainer && (block = (LiquidBlockContainer)block2).m_6044_((BlockGetter)level, pos, state, this.fluid.get());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityProvider(stack);
    }

    static class CapabilityProvider
    implements ICapabilityProvider,
    IFluidHandlerItem {
        private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
        private ItemStack container;

        public CapabilityProvider(ItemStack container) {
            this.container = container;
        }

        @NotNull
        public ItemStack getContainer() {
            return this.container;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, this.holder);
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.getFluid();
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return stack.getFluid() == Fluids.f_76195_ || stack.getFluid() == Fluids.f_76193_ || stack.getFluid() == EFluids.WITCH_WATER.get() || ForgeMod.MILK.isPresent() && stack.getFluid() == ForgeMod.MILK.get();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.container.m_41613_() != 1 || resource.getAmount() < 1000 || !this.getFluid().isEmpty() || !this.isFluidValid(0, resource)) {
                return 0;
            }
            if (action.execute()) {
                this.setFluid(resource);
            }
            return 1000;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.container.m_41613_() != 1 || resource.getAmount() < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack stack = this.getFluid();
            if (!stack.isEmpty() && stack.isFluidEqual(resource)) {
                if (action.execute()) {
                    this.setFluid(FluidStack.EMPTY);
                }
                return stack;
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.container.m_41613_() != 1 || maxDrain < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidStack = this.getFluid();
            if (!fluidStack.isEmpty()) {
                if (action.execute()) {
                    this.setFluid(FluidStack.EMPTY);
                }
                return fluidStack;
            }
            return FluidStack.EMPTY;
        }

        FluidStack getFluid() {
            Item item = this.container.m_41720_();
            if (item == EItems.PORCELAIN_LAVA_BUCKET.get()) {
                return new FluidStack((Fluid)Fluids.f_76195_, 1000);
            }
            if (item == EItems.PORCELAIN_WATER_BUCKET.get()) {
                return new FluidStack((Fluid)Fluids.f_76193_, 1000);
            }
            if (item == EItems.PORCELAIN_WITCH_WATER_BUCKET.get()) {
                return new FluidStack((Fluid)EFluids.WITCH_WATER.get(), 1000);
            }
            if (item == EItems.PORCELAIN_MILK_BUCKET.get() && ForgeMod.MILK.isPresent()) {
                return new FluidStack((Fluid)ForgeMod.MILK.get(), 1000);
            }
            return FluidStack.EMPTY;
        }

        protected void setFluid(FluidStack fluidStack) {
            if (fluidStack.isEmpty()) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_BUCKET.get());
            } else if (fluidStack.getFluid() == Fluids.f_76195_) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_LAVA_BUCKET.get());
            } else if (fluidStack.getFluid() == Fluids.f_76193_) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_WATER_BUCKET.get());
            } else if (fluidStack.getFluid() == EFluids.WITCH_WATER.get()) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_WITCH_WATER_BUCKET.get());
            } else if (ForgeMod.MILK.isPresent() && fluidStack.getFluid() == ForgeMod.MILK.get()) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_MILK_BUCKET.get());
            }
        }
    }
}

