/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.mutable.MutableInt;
import thedarkcolour.exdeorum.compat.XeiSieveRecipe;
import thedarkcolour.exdeorum.compat.XeiUtil;
import thedarkcolour.exdeorum.compat.jei.ClientJeiUtil;
import thedarkcolour.exdeorum.compat.jei.ExDeorumJeiPlugin;
import thedarkcolour.exdeorum.material.DefaultMaterials;

class SieveCategory
implements IRecipeCategory<XeiSieveRecipe> {
    private final IDrawable background = new Background();
    private final IDrawable slot;
    private final IDrawable row;
    private final IDrawable icon;
    private final Component title;
    private final MutableInt rows;

    SieveCategory(IGuiHelper helper, ItemLike icon, Component title, MutableInt rows) {
        this.slot = helper.getSlotDrawable();
        this.row = helper.createDrawable(ExDeorumJeiPlugin.EX_DEORUM_JEI_TEXTURE, 0, 0, 162, 18);
        this.icon = helper.createDrawableItemStack(new ItemStack(icon));
        this.title = title;
        this.rows = rows;
    }

    SieveCategory(IGuiHelper helper) {
        this(helper, DefaultMaterials.OAK_SIEVE, (Component)Component.m_237115_((String)"gui.exdeorum.category.sieve"), XeiSieveRecipe.SIEVE_ROWS);
    }

    public RecipeType<XeiSieveRecipe> getRecipeType() {
        return ExDeorumJeiPlugin.SIEVE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, XeiSieveRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 59, 1).addIngredients(recipe.ingredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 87, 1).addItemStack(recipe.mesh());
        for (int i = 0; i < recipe.results().size(); ++i) {
            XeiSieveRecipe.Result result = recipe.results().get(i);
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 1 + i % 9 * 18, 29 + 18 * (i / 9)).addItemStack(result.item);
            SieveCategory.addTooltips(slot, result.byHandOnly, result.provider);
        }
    }

    public static void addTooltips(IRecipeSlotBuilder slot, boolean byHandOnly, NumberProvider provider) {
        if (byHandOnly) {
            slot.setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)ClientJeiUtil.AsteriskItemRenderer.INSTANCE);
        }
        slot.addTooltipCallback((slotView, tooltip) -> XeiUtil.addSieveDropTooltip(byHandOnly, provider, tooltip::add));
    }

    public void draw(XeiSieveRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.slot.draw(graphics, 58, 0);
        this.slot.draw(graphics, 86, 0);
        int rows = this.rows.intValue();
        for (int i = 0; i < rows; ++i) {
            this.row.draw(graphics, 0, 28 + i * 18);
        }
    }

    private class Background
    implements IDrawable {
        private Background() {
        }

        public int getWidth() {
            return 162;
        }

        public int getHeight() {
            return 28 + 18 * SieveCategory.this.rows.intValue();
        }

        public void draw(GuiGraphics guiGraphics, int i, int i1) {
        }
    }
}

