/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import thedarkcolour.exdeorum.client.screen.MechanicalHammerScreen;
import thedarkcolour.exdeorum.client.screen.MechanicalSieveScreen;
import thedarkcolour.exdeorum.client.screen.RedstoneControlWidget;
import thedarkcolour.exdeorum.compat.CompatHelper;
import thedarkcolour.exdeorum.compat.XeiSieveRecipe;
import thedarkcolour.exdeorum.compat.XeiUtil;
import thedarkcolour.exdeorum.compat.jei.BarrelCompostCategory;
import thedarkcolour.exdeorum.compat.jei.BarrelMixingCategory;
import thedarkcolour.exdeorum.compat.jei.CompressedSieveCategory;
import thedarkcolour.exdeorum.compat.jei.CrookCategory;
import thedarkcolour.exdeorum.compat.jei.CrookJeiRecipe;
import thedarkcolour.exdeorum.compat.jei.CrucibleCategory;
import thedarkcolour.exdeorum.compat.jei.CrucibleHeatSourceRecipe;
import thedarkcolour.exdeorum.compat.jei.CrucibleHeatSourcesCategory;
import thedarkcolour.exdeorum.compat.jei.HammerCategory;
import thedarkcolour.exdeorum.compat.jei.SieveCategory;
import thedarkcolour.exdeorum.item.WateringCanItem;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.barrel.BarrelCompostRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelFluidMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelMixingRecipe;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleRecipe;
import thedarkcolour.exdeorum.recipe.hammer.CompressedHammerRecipe;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;
import thedarkcolour.exdeorum.recipe.sieve.SieveRecipe;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.registry.ERecipeTypes;
import thedarkcolour.exdeorum.tag.EItemTags;

@JeiPlugin
public class ExDeorumJeiPlugin
implements IModPlugin {
    public static final ResourceLocation EX_DEORUM_JEI_TEXTURE = new ResourceLocation("exdeorum", "textures/gui/jei/enr_jei.png");
    static final RecipeType<BarrelCompostRecipe> BARREL_COMPOST = ExDeorumJeiPlugin.recipeType("barrel_compost", BarrelCompostRecipe.class);
    static final RecipeType<BarrelMixingRecipe> BARREL_MIXING = ExDeorumJeiPlugin.recipeType("barrel_mixing", BarrelMixingRecipe.class);
    static final RecipeType<BarrelFluidMixingRecipe> BARREL_FLUID_MIXING = ExDeorumJeiPlugin.recipeType("barrel_fluid_mixing", BarrelFluidMixingRecipe.class);
    static final RecipeType<CrucibleRecipe> LAVA_CRUCIBLE = ExDeorumJeiPlugin.recipeType("lava_crucible", CrucibleRecipe.class);
    static final RecipeType<CrucibleRecipe> WATER_CRUCIBLE = ExDeorumJeiPlugin.recipeType("water_crucible", CrucibleRecipe.class);
    static final RecipeType<CrucibleHeatSourceRecipe> CRUCIBLE_HEAT_SOURCES = ExDeorumJeiPlugin.recipeType("crucible_heat_sources", CrucibleHeatSourceRecipe.class);
    static final RecipeType<XeiSieveRecipe> SIEVE = ExDeorumJeiPlugin.recipeType("sieve", XeiSieveRecipe.class);
    static final RecipeType<XeiSieveRecipe> COMPRESSED_SIEVE = ExDeorumJeiPlugin.recipeType("compressed_sieve", XeiSieveRecipe.class);
    static final RecipeType<HammerRecipe> HAMMER = ExDeorumJeiPlugin.recipeType("hammer", HammerRecipe.class);
    static final RecipeType<HammerRecipe> COMPRESSED_HAMMER = ExDeorumJeiPlugin.recipeType("compressed_hammer", CompressedHammerRecipe.class);
    static final RecipeType<CrookJeiRecipe> CROOK = ExDeorumJeiPlugin.recipeType("crook", CrookJeiRecipe.class);

    private static <T> RecipeType<T> recipeType(String path, Class<? extends T> type) {
        return RecipeType.create((String)"exdeorum", (String)path, type);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("exdeorum", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        IDrawableStatic arrow = helper.createDrawable(EX_DEORUM_JEI_TEXTURE, 0, 18, 22, 15);
        IDrawableStatic plus = helper.createDrawable(EX_DEORUM_JEI_TEXTURE, 22, 18, 8, 8);
        registration.addRecipeCategories(new IRecipeCategory[]{new BarrelCompostCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BarrelMixingCategory.Items(helper, (IDrawable)plus, (IDrawable)arrow)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BarrelMixingCategory.Fluids(helper, (IDrawable)plus, (IDrawable)arrow)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleCategory.LavaCrucible(helper, (IDrawable)arrow)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleCategory.WaterCrucible(helper, (IDrawable)arrow)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleHeatSourcesCategory(registration.getJeiHelpers())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SieveCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressedSieveCategory(helper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HammerCategory(helper, (IDrawable)arrow, (Supplier<? extends Item>)EItems.DIAMOND_HAMMER, (Component)Component.m_237115_((String)"gui.exdeorum.category.hammer"), HAMMER)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HammerCategory(helper, (IDrawable)arrow, (Supplier<? extends Item>)EItems.COMPRESSED_DIAMOND_HAMMER, (Component)Component.m_237115_((String)"gui.exdeorum.category.compressed_hammer"), COMPRESSED_HAMMER)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrookCategory(registration.getJeiHelpers(), (IDrawable)arrow)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack stack;
        for (ItemLike barrel : CompatHelper.getAvailableBarrels(true)) {
            stack = new ItemStack(barrel);
            registration.addRecipeCatalyst(stack, new RecipeType[]{BARREL_COMPOST});
            registration.addRecipeCatalyst(stack, new RecipeType[]{BARREL_MIXING});
            registration.addRecipeCatalyst(stack, new RecipeType[]{BARREL_FLUID_MIXING});
        }
        for (ItemLike lavaCrucible : CompatHelper.getAvailableLavaCrucibles(true)) {
            stack = new ItemStack(lavaCrucible);
            registration.addRecipeCatalyst(stack, new RecipeType[]{LAVA_CRUCIBLE});
            registration.addRecipeCatalyst(stack, new RecipeType[]{CRUCIBLE_HEAT_SOURCES});
        }
        for (ItemLike waterCrucible : CompatHelper.getAvailableWaterCrucibles(true)) {
            registration.addRecipeCatalyst(new ItemStack(waterCrucible), new RecipeType[]{WATER_CRUCIBLE});
        }
        for (ItemLike sieve : CompatHelper.getAvailableSieves(true, true)) {
            registration.addRecipeCatalyst(new ItemStack(sieve), new RecipeType[]{SIEVE});
        }
        for (ItemLike compressedSieve : CompatHelper.getAvailableCompressedSieves(true)) {
            registration.addRecipeCatalyst(new ItemStack(compressedSieve), new RecipeType[]{COMPRESSED_SIEVE});
        }
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.WOODEN_HAMMER.get()), new RecipeType[]{HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.STONE_HAMMER.get()), new RecipeType[]{HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.GOLDEN_HAMMER.get()), new RecipeType[]{HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.IRON_HAMMER.get()), new RecipeType[]{HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.DIAMOND_HAMMER.get()), new RecipeType[]{HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.NETHERITE_HAMMER.get()), new RecipeType[]{HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.MECHANICAL_HAMMER.get()), new RecipeType[]{HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.COMPRESSED_WOODEN_HAMMER.get()), new RecipeType[]{COMPRESSED_HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.COMPRESSED_STONE_HAMMER.get()), new RecipeType[]{COMPRESSED_HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.COMPRESSED_GOLDEN_HAMMER.get()), new RecipeType[]{COMPRESSED_HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.COMPRESSED_IRON_HAMMER.get()), new RecipeType[]{COMPRESSED_HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.COMPRESSED_DIAMOND_HAMMER.get()), new RecipeType[]{COMPRESSED_HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.COMPRESSED_NETHERITE_HAMMER.get()), new RecipeType[]{COMPRESSED_HAMMER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.CROOK.get()), new RecipeType[]{CROOK});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EItems.BONE_CROOK.get()), new RecipeType[]{CROOK});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addItemStackInfo(List.of(new ItemStack((ItemLike)EItems.INFESTED_LEAVES.get()), new ItemStack((ItemLike)EItems.SILK_WORM.get())), new Component[]{Component.m_237115_((String)"info.exdeorum.silk_worm")});
        registration.addItemStackInfo(CompatHelper.getAvailableSieves(true, false).stream().map(ItemStack::new).toList(), new Component[]{Component.m_237115_((String)"info.exdeorum.sieve")});
        registration.addItemStackInfo(List.of(new ItemStack((ItemLike)EItems.STRING_MESH.get()), new ItemStack((ItemLike)EItems.STRING_MESH.get()), new ItemStack((ItemLike)EItems.FLINT_MESH.get()), new ItemStack((ItemLike)EItems.IRON_MESH.get()), new ItemStack((ItemLike)EItems.GOLDEN_MESH.get()), new ItemStack((ItemLike)EItems.DIAMOND_MESH.get()), new ItemStack((ItemLike)EItems.NETHERITE_MESH.get())), new Component[]{Component.m_237115_((String)"info.exdeorum.sieve_mesh")});
        registration.addItemStackInfo(List.of(WateringCanItem.getFull(EItems.WOODEN_WATERING_CAN), WateringCanItem.getFull(EItems.STONE_WATERING_CAN), WateringCanItem.getFull(EItems.IRON_WATERING_CAN), WateringCanItem.getFull(EItems.GOLDEN_WATERING_CAN), WateringCanItem.getFull(EItems.DIAMOND_WATERING_CAN), WateringCanItem.getFull(EItems.NETHERITE_WATERING_CAN)), new Component[]{Component.m_237115_((String)"info.exdeorum.watering_can")});
        MutableComponent witchWaterInfo = Component.m_237115_((String)"info.exdeorum.witch_water");
        registration.addItemStackInfo(List.of(new ItemStack((ItemLike)EItems.WITCH_WATER_BUCKET.get()), new ItemStack((ItemLike)EItems.PORCELAIN_WITCH_WATER_BUCKET.get())), new Component[]{witchWaterInfo});
        registration.addIngredientInfo((Object)new FluidStack((Fluid)EFluids.WITCH_WATER.get(), 1000), (IIngredientType)ForgeTypes.FLUID_STACK, new Component[]{witchWaterInfo});
        registration.addItemStackInfo(new ItemStack((ItemLike)EItems.GRASS_SEEDS.get()), new Component[]{Component.m_237115_((String)"info.exdeorum.grass_seeds")});
        registration.addItemStackInfo(new ItemStack((ItemLike)EItems.MYCELIUM_SPORES.get()), new Component[]{Component.m_237115_((String)"info.exdeorum.mycelium_spores")});
        registration.addItemStackInfo(new ItemStack((ItemLike)EItems.WARPED_NYLIUM_SPORES.get()), new Component[]{Component.m_237115_((String)"info.exdeorum.warped_nylium_spores")});
        registration.addItemStackInfo(new ItemStack((ItemLike)EItems.CRIMSON_NYLIUM_SPORES.get()), new Component[]{Component.m_237115_((String)"info.exdeorum.crimson_nylium_spores")});
        registration.addItemStackInfo(new ItemStack((ItemLike)EItems.SCULK_CORE.get()), new Component[]{Component.m_237115_((String)"info.exdeorum.sculk_core")});
        registration.addItemStackInfo(new ItemStack((ItemLike)EItems.MECHANICAL_SIEVE.get()), new Component[]{Component.m_237115_((String)"info.exdeorum.mechanical_sieve")});
        registration.addItemStackInfo(new ItemStack((ItemLike)EItems.MECHANICAL_HAMMER.get()), new Component[]{Component.m_237115_((String)"info.exdeorum.mechanical_hammer")});
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_ALUMINUM)) {
            toRemove.add(new ItemStack((ItemLike)EItems.ALUMINUM_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_COBALT)) {
            toRemove.add(new ItemStack((ItemLike)EItems.COBALT_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_SILVER)) {
            toRemove.add(new ItemStack((ItemLike)EItems.SILVER_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_LEAD)) {
            toRemove.add(new ItemStack((ItemLike)EItems.LEAD_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_PLATINUM)) {
            toRemove.add(new ItemStack((ItemLike)EItems.PLATINUM_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_NICKEL)) {
            toRemove.add(new ItemStack((ItemLike)EItems.NICKEL_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_URANIUM)) {
            toRemove.add(new ItemStack((ItemLike)EItems.URANIUM_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_OSMIUM)) {
            toRemove.add(new ItemStack((ItemLike)EItems.OSMIUM_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_TIN)) {
            toRemove.add(new ItemStack((ItemLike)EItems.TIN_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_ZINC)) {
            toRemove.add(new ItemStack((ItemLike)EItems.ZINC_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_IRIDIUM)) {
            toRemove.add(new ItemStack((ItemLike)EItems.IRIDIUM_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_THORIUM)) {
            toRemove.add(new ItemStack((ItemLike)EItems.THORIUM_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_MAGNESIUM)) {
            toRemove.add(new ItemStack((ItemLike)EItems.MAGNESIUM_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_LITHIUM)) {
            toRemove.add(new ItemStack((ItemLike)EItems.LITHIUM_ORE_CHUNK.get()));
        }
        if (RecipeUtil.isTagEmpty(EItemTags.ORES_BORON)) {
            toRemove.add(new ItemStack((ItemLike)EItems.BORON_ORE_CHUNK.get()));
        }
        if (!toRemove.isEmpty()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, toRemove);
        }
        ExDeorumJeiPlugin.addRecipes(registration, BARREL_COMPOST, ERecipeTypes.BARREL_COMPOST);
        ExDeorumJeiPlugin.addRecipes(registration, BARREL_MIXING, ERecipeTypes.BARREL_MIXING);
        ExDeorumJeiPlugin.addRecipes(registration, BARREL_FLUID_MIXING, ERecipeTypes.BARREL_FLUID_MIXING);
        ExDeorumJeiPlugin.addRecipes(registration, LAVA_CRUCIBLE, ERecipeTypes.LAVA_CRUCIBLE);
        ExDeorumJeiPlugin.addRecipes(registration, WATER_CRUCIBLE, ERecipeTypes.WATER_CRUCIBLE);
        ExDeorumJeiPlugin.addRecipes(registration, HAMMER, ERecipeTypes.HAMMER);
        ExDeorumJeiPlugin.addRecipes(registration, COMPRESSED_HAMMER, ERecipeTypes.COMPRESSED_HAMMER);
        ArrayList<CrookJeiRecipe> crookRecipes = new ArrayList<CrookJeiRecipe>();
        for (CrookRecipe recipe : Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)ERecipeTypes.CROOK.get())) {
            crookRecipes.add(CrookJeiRecipe.create(recipe));
        }
        registration.addRecipes(CROOK, crookRecipes);
        registration.addRecipes(SIEVE, XeiSieveRecipe.getAllRecipesGrouped((net.minecraft.world.item.crafting.RecipeType<? extends SieveRecipe>)((net.minecraft.world.item.crafting.RecipeType)ERecipeTypes.SIEVE.get()), XeiSieveRecipe.SIEVE_ROWS));
        registration.addRecipes(COMPRESSED_SIEVE, XeiSieveRecipe.getAllRecipesGrouped((net.minecraft.world.item.crafting.RecipeType<? extends SieveRecipe>)((net.minecraft.world.item.crafting.RecipeType)ERecipeTypes.COMPRESSED_SIEVE.get()), XeiSieveRecipe.COMPRESSED_SIEVE_ROWS));
        ExDeorumJeiPlugin.addCrucibleHeatSources(registration);
    }

    private static void addCrucibleHeatSources(IRecipeRegistration registration) {
        IPlatformFluidHelper fluidHelper = registration.getJeiHelpers().getPlatformFluidHelper();
        IIngredientTypeWithSubtypes fluidIngredientType = fluidHelper.getFluidIngredientType();
        ArrayList recipes = new ArrayList();
        XeiUtil.addCrucibleHeatRecipes((heat, state) -> {
            Block patt15499$temp = state.m_60734_();
            if (patt15499$temp instanceof LiquidBlock) {
                LiquidBlock liquid = (LiquidBlock)patt15499$temp;
                recipes.add(new CrucibleHeatSourceRecipe(heat, state, (IIngredientType)fluidIngredientType, fluidHelper.create((Fluid)liquid.getFluid(), 1000L)));
            } else {
                Item itemForm = state.m_60734_().m_5456_();
                if (itemForm != Items.f_41852_) {
                    recipes.add(new CrucibleHeatSourceRecipe(heat, state, (IIngredientType)VanillaTypes.ITEM_STACK, new ItemStack((ItemLike)itemForm)));
                } else {
                    recipes.add(new CrucibleHeatSourceRecipe(heat, state, null, null));
                }
            }
        });
        registration.addRecipes(CRUCIBLE_HEAT_SOURCES, recipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(MechanicalSieveScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<MechanicalSieveScreen>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(MechanicalSieveScreen containerScreen, double mouseX, double mouseY) {
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)51, (int)42, (int)21, (int)14, (RecipeType[])new RecipeType[]{SIEVE});
                return ModList.get().isLoaded("emi") ? List.of() : List.of(clickableArea);
            }

            public List<Rect2i> getGuiExtraAreas(MechanicalSieveScreen containerScreen) {
                RedstoneControlWidget widget = containerScreen.getRedstoneControlWidget();
                if (widget != null) {
                    return widget.getJeiBounds();
                }
                return List.of();
            }
        });
        registration.addGuiContainerHandler(MechanicalHammerScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<MechanicalHammerScreen>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(MechanicalHammerScreen containerScreen, double mouseX, double mouseY) {
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)80, (int)34, (int)23, (int)16, (RecipeType[])new RecipeType[]{HAMMER});
                return ModList.get().isLoaded("emi") ? List.of() : List.of(clickableArea);
            }

            public List<Rect2i> getGuiExtraAreas(MechanicalHammerScreen containerScreen) {
                RedstoneControlWidget widget = containerScreen.getRedstoneControlWidget();
                if (widget != null) {
                    return widget.getJeiBounds();
                }
                return List.of();
            }
        });
    }

    private static <C extends Container, T extends Recipe<C>> void addRecipes(IRecipeRegistration registration, RecipeType<T> category, Supplier<net.minecraft.world.item.crafting.RecipeType<T>> type) {
        registration.addRecipes(category, Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_().m_44013_(type.get()));
    }
}

