/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import thedarkcolour.exdeorum.compat.ClientXeiUtil;
import thedarkcolour.exdeorum.compat.jei.ClientJeiUtil;
import thedarkcolour.exdeorum.compat.jei.CrucibleHeatSourceRecipe;
import thedarkcolour.exdeorum.compat.jei.ExDeorumJeiPlugin;
import thedarkcolour.exdeorum.material.DefaultMaterials;

class CrucibleHeatSourcesCategory
implements IRecipeCategory<CrucibleHeatSourceRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;
    private final IFocusFactory focusFactory;
    private final IIngredientManager ingredientManager;
    private final IModIdHelper modIdHelper;

    public CrucibleHeatSourcesCategory(IJeiHelpers helpers) {
        IGuiHelper helper = helpers.getGuiHelper();
        this.background = helper.createBlankDrawable(120, 48);
        this.title = Component.m_237115_((String)"gui.exdeorum.category.crucible_heat_source");
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)DefaultMaterials.PORCELAIN_CRUCIBLE.getItem()));
        this.focusFactory = helpers.getFocusFactory();
        this.ingredientManager = helpers.getIngredientManager();
        this.modIdHelper = helpers.getModIdHelper();
    }

    public RecipeType<CrucibleHeatSourceRecipe> getRecipeType() {
        return ExDeorumJeiPlugin.CRUCIBLE_HEAT_SOURCES;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrucibleHeatSourceRecipe recipe, IFocusGroup focuses) {
        if (recipe.ingredientType() != null) {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredient(recipe.ingredientType(), recipe.ingredient());
        } else {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ItemStack.f_41583_);
        }
    }

    public void draw(CrucibleHeatSourceRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int volume = recipe.meltRate();
        MutableComponent volumeLabel = Component.m_237110_((String)"gui.exdeorum.category.crucible_heat_source.multiplier", (Object[])new Object[]{volume});
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280614_(font, (Component)volumeLabel, 60 - font.m_92852_((FormattedText)volumeLabel) / 2, 5, -8355712, false);
        ClientXeiUtil.renderBlock(graphics, recipe.blockState(), 60.0f, 24.0f, 10.0f, 20.0f);
    }

    public List<Component> getTooltipStrings(CrucibleHeatSourceRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (44.0 < mouseX && mouseX < 76.0 && 16.0 < mouseY && mouseY < 48.0) {
            if (recipe.ingredientType() != null) {
                List tooltip = this.ingredientManager.getIngredientRenderer(recipe.ingredientType()).getTooltip(recipe.ingredient(), (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_));
                return this.modIdHelper.addModNameToIngredientTooltip(tooltip, recipe.ingredient(), this.ingredientManager.getIngredientHelper(recipe.ingredientType()));
            }
            Block block = recipe.blockState().m_60734_();
            String modId = ForgeRegistries.BLOCKS.getKey((Object)block).m_135827_();
            return List.of(Component.m_237115_((String)block.m_7705_()), Component.m_237113_((String)this.modIdHelper.getFormattedModNameForModId(modId)));
        }
        return List.of();
    }

    public boolean handleInput(CrucibleHeatSourceRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && (input.m_84873_() == 0 || input.m_84873_() == 1) && 44.0 < mouseX && mouseX < 76.0 && 16.0 < mouseY && mouseY < 48.0) {
            if (recipe.ingredientType() != null) {
                ClientJeiUtil.checkTypedIngredient(this.ingredientManager, recipe.ingredientType(), recipe.ingredient(), ingredient -> {
                    if (input.m_84873_() == 0) {
                        ClientJeiUtil.showRecipes(this.focusFactory, ingredient);
                    } else if (input.m_84873_() == 1) {
                        ClientJeiUtil.showUsages(this.focusFactory, ingredient);
                    }
                });
            }
            return true;
        }
        return false;
    }

    public int getHeight() {
        return 48;
    }
}

