/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import thedarkcolour.exdeorum.compat.ClientXeiUtil;

class ClientJeiUtil {
    ClientJeiUtil() {
    }

    public static <T> void checkTypedIngredient(IIngredientManager manager, IIngredientType<T> ingredientType, T uncheckedIngredient, Consumer<ITypedIngredient<T>> action) {
        FluidStack fluidStack;
        ItemStack stack;
        if (uncheckedIngredient instanceof ItemStack && !(stack = (ItemStack)uncheckedIngredient).m_41619_() || uncheckedIngredient instanceof FluidStack && !(fluidStack = (FluidStack)uncheckedIngredient).isEmpty()) {
            manager.createTypedIngredient(ingredientType, uncheckedIngredient).ifPresent(action);
        }
    }

    public static <T> void showRecipes(IFocusFactory focusFactory, ITypedIngredient<T> ingredient) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof IRecipesGui) {
            IRecipesGui recipesGui = (IRecipesGui)screen;
            recipesGui.show(focusFactory.createFocus(RecipeIngredientRole.OUTPUT, ingredient));
        } else if (ModList.get().isLoaded("rei_plugin_compatibilities")) {
            ViewSearchBuilder.builder().addRecipesFor(JEIPluginDetector.unwrapStack(ingredient)).open();
        }
    }

    public static <T> void showUsages(IFocusFactory focusFactory, ITypedIngredient<T> ingredient) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof IRecipesGui) {
            IRecipesGui recipesGui = (IRecipesGui)screen;
            recipesGui.show(List.of(focusFactory.createFocus(RecipeIngredientRole.INPUT, ingredient), focusFactory.createFocus(RecipeIngredientRole.CATALYST, ingredient)));
        } else if (ModList.get().isLoaded("rei_plugin_compatibilities")) {
            ViewSearchBuilder.builder().addUsagesFor(JEIPluginDetector.unwrapStack(ingredient)).open();
        }
    }

    static enum AsteriskItemRenderer implements IIngredientRenderer<ItemStack>
    {
        INSTANCE;


        public void render(GuiGraphics graphics, ItemStack ingredient) {
            RenderSystem.enableDepthTest();
            ClientXeiUtil.renderItemWithAsterisk(graphics, ingredient);
            RenderSystem.disableDepthTest();
        }

        public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            try {
                return ingredient.m_41651_((Player)player, tooltipFlag);
            }
            catch (LinkageError | RuntimeException e) {
                ArrayList<Component> list = new ArrayList<Component>();
                MutableComponent crash = Component.m_237115_((String)"jei.tooltip.error.crash");
                list.add((Component)crash.m_130940_(ChatFormatting.RED));
                return list;
            }
        }
    }
}

