/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import thedarkcolour.exdeorum.compat.ClientXeiUtil;
import thedarkcolour.exdeorum.compat.jei.ExDeorumJeiPlugin;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.recipe.barrel.BarrelFluidMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelMixingRecipe;

abstract class BarrelMixingCategory<T>
implements IRecipeCategory<T> {
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable plus;
    private final IDrawable arrow;
    private final IDrawable icon;
    private final Component title;

    public BarrelMixingCategory(IGuiHelper helper, IDrawable plus, IDrawable arrow, String titleKey, Item iconItem) {
        this.background = helper.createBlankDrawable(120, 18);
        this.slot = helper.getSlotDrawable();
        this.plus = plus;
        this.arrow = arrow;
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)iconItem));
        this.title = Component.m_237115_((String)titleKey);
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.slot.draw(graphics);
        this.plus.draw(graphics, 21, 5);
        this.slot.draw(graphics, 32, 0);
        this.arrow.draw(graphics, 53, 1);
        this.slot.draw(graphics, 78, 0);
    }

    static class Fluids
    extends BarrelMixingCategory<BarrelFluidMixingRecipe> {
        private static final Component CONTENTS_ARE_CONSUMED_TOOLTIP = Component.m_237115_((String)"gui.exdeorum.category.barrel_fluid_mixing.contents_are_consumed").m_130940_(ChatFormatting.RED);

        public Fluids(IGuiHelper helper, IDrawable plus, IDrawable arrow) {
            super(helper, plus, arrow, "gui.exdeorum.category.barrel_fluid_mixing", DefaultMaterials.STONE_BARREL.getItem());
        }

        public void setRecipe(IRecipeLayoutBuilder builder, BarrelFluidMixingRecipe recipe, IFocusGroup focuses) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addFluidStack(recipe.baseFluid, (long)recipe.baseFluidAmount)).setFluidRenderer(1000L, false, 16, 16);
            IRecipeSlotBuilder additiveSlot = ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 33, 1).addFluidStack(recipe.additiveFluid, 1000L)).setFluidRenderer(1000L, false, 16, 16);
            if (recipe.consumesAdditive) {
                additiveSlot.addTooltipCallback((view, tooltip) -> tooltip.add(CONTENTS_ARE_CONSUMED_TOOLTIP));
            }
            ItemStack result = new ItemStack((ItemLike)recipe.result);
            result.m_41751_(recipe.getResultNbt());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 79, 1).addItemStack(result);
        }

        public RecipeType<BarrelFluidMixingRecipe> getRecipeType() {
            return ExDeorumJeiPlugin.BARREL_FLUID_MIXING;
        }

        @Override
        public void draw(BarrelFluidMixingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
            super.draw(recipe, recipeSlotsView, graphics, mouseX, mouseY);
            if (recipe.consumesAdditive) {
                ClientXeiUtil.renderAsterisk(graphics, 32, 0);
            }
        }
    }

    static class Items
    extends BarrelMixingCategory<BarrelMixingRecipe> {
        public Items(IGuiHelper helper, IDrawable plus, IDrawable arrow) {
            super(helper, plus, arrow, "gui.exdeorum.category.barrel_mixing", DefaultMaterials.OAK_BARREL.getItem());
        }

        public void setRecipe(IRecipeLayoutBuilder builder, BarrelMixingRecipe recipe, IFocusGroup focuses) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addFluidStack(recipe.fluid, (long)recipe.fluidAmount)).setFluidRenderer(1000L, false, 16, 16);
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 1).addIngredients(recipe.getIngredient());
            ItemStack result = new ItemStack((ItemLike)recipe.result);
            result.m_41751_(recipe.getResultNbt());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 79, 1).addItemStack(result);
        }

        public RecipeType<BarrelMixingRecipe> getRecipeType() {
            return ExDeorumJeiPlugin.BARREL_MIXING;
        }
    }
}

