/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import thedarkcolour.exdeorum.material.AbstractMaterial;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.material.MaterialRegistry;
import thedarkcolour.exdeorum.registry.EItems;

public class CompatHelper {
    public static List<ItemLike> getAvailableBarrels(boolean registered) {
        return CompatHelper.getAvailableMaterials(DefaultMaterials.BARRELS, registered);
    }

    public static List<ItemLike> getAvailableSieves(boolean registered, boolean includeMechanical) {
        List<ItemLike> sieves = CompatHelper.getAvailableMaterials(DefaultMaterials.SIEVES, registered);
        if (includeMechanical) {
            sieves.add((ItemLike)EItems.MECHANICAL_SIEVE.get());
        }
        return sieves;
    }

    public static List<ItemLike> getAvailableLavaCrucibles(boolean registered) {
        return CompatHelper.getAvailableMaterials(DefaultMaterials.LAVA_CRUCIBLES, registered);
    }

    public static List<ItemLike> getAvailableWaterCrucibles(boolean registered) {
        return CompatHelper.getAvailableMaterials(DefaultMaterials.WATER_CRUCIBLES, registered);
    }

    public static List<ItemLike> getAvailableCompressedSieves(boolean registered) {
        return CompatHelper.getAvailableMaterials(DefaultMaterials.COMPRESSED_SIEVES, registered);
    }

    private static List<ItemLike> getAvailableMaterials(MaterialRegistry<?> registry, boolean registered) {
        ArrayList<ItemLike> materials = new ArrayList<ItemLike>();
        for (AbstractMaterial material : registry) {
            if (registered != ModList.get().isLoaded(material.requiredModId)) continue;
            materials.add(material);
        }
        return materials;
    }
}

