/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.EBlock;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.MechanicalHammerBlockEntity;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.registry.EBlockEntities;

public class MechanicalHammerBlock
extends EBlock {
    public static final BooleanProperty RUNNING = BooleanProperty.m_61465_((String)"running");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public MechanicalHammerBlock(BlockBehaviour.Properties properties) {
        super(properties, (Supplier<? extends BlockEntityType<?>>)EBlockEntities.MECHANICAL_HAMMER);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)RUNNING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RUNNING, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == EBlockEntities.MECHANICAL_HAMMER.get() && !level.f_46443_ ? new AbstractMachineBlockEntity.ServerTicker() : null;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag nbt = BlockItem.m_186336_((ItemStack)stack);
        if (nbt != null) {
            CompoundTag inventoryNbt = nbt.m_128469_("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryNbt);
            ItemStack hammer = inventory.getStackInSlot(1);
            if (!hammer.m_41619_()) {
                tooltip.add((Component)Component.m_237115_((String)"item.exdeorum.mechanical_hammer.hammer_label").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)hammer.m_41778_())));
            }
            int energy = nbt.m_128451_("energy");
            tooltip.add((Component)Component.m_237115_((String)"gui.exdeorum.energy_label").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)"item.exdeorum.watering_can_fluid_display", (Object[])new Object[]{energy, EConfig.SERVER.mechanicalSieveEnergyStorage.get()})).m_130946_(" FE"));
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState pState, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && player.m_7500_() && level.m_46469_().m_46207_(GameRules.f_46136_) && (blockEntity = level.m_7702_(pos)) instanceof MechanicalHammerBlockEntity) {
            MechanicalHammerBlockEntity sieve = (MechanicalHammerBlockEntity)blockEntity;
            if (!sieve.inventory.getStackInSlot(1).m_41619_()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)EBlockEntities.MECHANICAL_HAMMER.get()), (CompoundTag)sieve.m_187482_());
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(level, pos, pState, player);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        CompoundTag nbt = BlockItem.m_186336_((ItemStack)context.m_43722_());
        BlockState state = this.m_49966_();
        if (nbt != null && nbt.m_128441_("progress") && nbt.m_128451_("progress") != -1) {
            state = (BlockState)state.m_61124_((Property)RUNNING, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!oldState.m_60713_(state.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof MechanicalHammerBlockEntity) {
            MechanicalHammerBlockEntity hammer = (MechanicalHammerBlockEntity)blockEntity;
            hammer.checkPoweredState(level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MechanicalHammerBlockEntity) {
            MechanicalHammerBlockEntity hammer = (MechanicalHammerBlockEntity)blockEntity;
            hammer.checkPoweredState(level, pos);
        }
    }
}

