/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum;

import java.util.Calendar;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thedarkcolour.exdeorum.client.ClientHandler;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.event.EventHandler;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.network.NetworkHandler;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.EChunkGenerators;
import thedarkcolour.exdeorum.registry.ECreativeTabs;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EGlobalLootModifiers;
import thedarkcolour.exdeorum.registry.EItems;
import thedarkcolour.exdeorum.registry.ELootFunctions;
import thedarkcolour.exdeorum.registry.EMenus;
import thedarkcolour.exdeorum.registry.ENumberProviders;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;
import thedarkcolour.exdeorum.registry.ESounds;

@Mod(value="exdeorum")
public class ExDeorum {
    public static final String ID = "exdeorum";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"exdeorum");
    public static final boolean DEBUG = ModList.get().isLoaded("modkit");
    public static final boolean IS_JUNE = Calendar.getInstance().get(2) == 5;

    public ExDeorum() {
        ExDeorum.createRegistries();
        NetworkHandler.register();
        if (DatagenModLoader.isRunningDataGen()) {
            ForgeMod.enableMilkFluid();
        }
        EventHandler.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientHandlerRegistrar::register);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)EConfig.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)EConfig.CLIENT_SPEC);
    }

    private static void createRegistries() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        EBlocks.BLOCKS.register(modBus);
        EBlockEntities.BLOCK_ENTITIES.register(modBus);
        EChunkGenerators.CHUNK_GENERATORS.register(modBus);
        ECreativeTabs.CREATIVE_TABS.register(modBus);
        EFluids.FLUID_TYPES.register(modBus);
        EFluids.FLUIDS.register(modBus);
        EGlobalLootModifiers.GLOBAL_LOOT_MODIFIERS.register(modBus);
        EItems.ITEMS.register(modBus);
        ELootFunctions.LOOT_FUNCTIONS.register(modBus);
        ESounds.SOUNDS.register(modBus);
        EMenus.MENUS.register(modBus);
        ERecipeSerializers.RECIPE_SERIALIZERS.register(modBus);
        ERecipeTypes.RECIPE_TYPES.register(modBus);
        ENumberProviders.NUMBER_PROVIDERS.register(modBus);
        DefaultMaterials.registerMaterials();
    }

    private static interface ClientHandlerRegistrar {
        private static void register() {
            ClientHandler.register();
        }
    }
}

