/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.moddingx.libx.capability.ItemCapabilities;
import org.moddingx.libx.inventory.IAdvancedItemHandlerModifiable;
import org.moddingx.libx.inventory.VanillaWrapper;

public class ResizeBaseItemStackHandler
extends ItemStackHandler
implements IAdvancedItemHandlerModifiable {
    private final int size;
    private final int defaultSlotLimit;
    private final Set<Integer> insertionOnlySlots;
    private final Set<Integer> outputSlots;
    private static Map<Integer, Integer> slotLimits;
    private final Map<Integer, Predicate<ItemStack>> slotValidators;
    private final Consumer<Integer> contentsChanged;
    private Container vanilla = null;
    private Unrestricted unrestricted = null;

    private ResizeBaseItemStackHandler(int size, int defaultSlotLimit, Set<Integer> insertionOnlySlots, Set<Integer> outputSlots, Map<Integer, Integer> slotLimits, Map<Integer, Predicate<ItemStack>> slotValidators, Consumer<Integer> contentsChanged) {
        super(size);
        this.size = size;
        this.defaultSlotLimit = defaultSlotLimit;
        this.insertionOnlySlots = ImmutableSet.copyOf(insertionOnlySlots);
        this.outputSlots = ImmutableSet.copyOf(outputSlots);
        ResizeBaseItemStackHandler.slotLimits = ImmutableMap.copyOf(slotLimits);
        this.slotValidators = ImmutableMap.copyOf(slotValidators);
        this.contentsChanged = contentsChanged;
    }

    public void setSlotLimits(int limit) {
        HashMap<Integer, Integer> aa = new HashMap<Integer, Integer>();
        for (Integer slot : slotLimits.keySet()) {
            aa.put(slot, limit);
        }
        slotLimits = ImmutableMap.copyOf(aa);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.outputSlots.contains(slot) ? stack : super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.insertionOnlySlots.contains(slot) ? ItemStack.f_41583_ : super.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return slotLimits.getOrDefault(slot, this.defaultSlotLimit);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !this.slotValidators.containsKey(slot) || this.slotValidators.get(slot).test(stack);
    }

    public void onContentsChanged(int slot) {
        if (this.contentsChanged != null) {
            this.contentsChanged.accept(slot);
        }
    }

    protected void onLoad() {
        if (this.stacks.size() != this.size) {
            NonNullList oldStacks = this.stacks;
            this.stacks = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
            for (int slot = 0; slot < Math.min(oldStacks.size(), this.size); ++slot) {
                this.stacks.set(slot, (Object)((ItemStack)oldStacks.get(slot)));
            }
        }
    }

    public Container toVanilla() {
        if (this.vanilla == null) {
            this.vanilla = new VanillaWrapper((IItemHandlerModifiable)this, null);
        }
        return this.vanilla;
    }

    public IAdvancedItemHandlerModifiable getUnrestricted() {
        if (this.unrestricted == null) {
            this.unrestricted = new Unrestricted();
        }
        return this.unrestricted;
    }

    public LazyOptional<IAdvancedItemHandlerModifiable> createCapability() {
        return ItemCapabilities.create((IItemHandlerModifiable)this);
    }

    public LazyOptional<IAdvancedItemHandlerModifiable> createUnrestrictedCapability() {
        return ItemCapabilities.create(this::getUnrestricted);
    }

    public LazyOptional<IAdvancedItemHandlerModifiable> createCapability(@Nullable Predicate<Integer> extract, @Nullable BiPredicate<Integer, ItemStack> insert) {
        return ItemCapabilities.create((IItemHandlerModifiable)this, extract, insert);
    }

    public static Builder builder(int size) {
        return new Builder(size);
    }

    private class Unrestricted
    implements IAdvancedItemHandlerModifiable {
        private Unrestricted() {
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            ResizeBaseItemStackHandler.this.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return ResizeBaseItemStackHandler.this.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ResizeBaseItemStackHandler.this.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ResizeBaseItemStackHandler.this.validateSlotIndex(slot);
            ItemStack current = (ItemStack)ResizeBaseItemStackHandler.this.stacks.get(slot);
            int amount = ResizeBaseItemStackHandler.this.getStackLimit(slot, stack);
            if (!current.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)current)) {
                    return stack;
                }
                amount -= current.m_41613_();
            }
            if (amount <= 0) {
                return stack;
            }
            if (!simulate) {
                if (current.m_41619_()) {
                    ResizeBaseItemStackHandler.this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)Math.min(stack.m_41613_(), amount)));
                } else {
                    current.m_41769_(Math.min(stack.m_41613_(), amount));
                }
                ResizeBaseItemStackHandler.this.onContentsChanged(slot);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)Math.max(0, stack.m_41613_() - amount));
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0) {
                return ItemStack.f_41583_;
            }
            ResizeBaseItemStackHandler.this.validateSlotIndex(slot);
            ItemStack current = (ItemStack)ResizeBaseItemStackHandler.this.stacks.get(slot);
            if (current.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int count = Math.min(current.m_41613_(), Math.min(amount, current.m_41741_()));
            if (!simulate) {
                ResizeBaseItemStackHandler.this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)Math.max(0, current.m_41613_() - count)));
                ResizeBaseItemStackHandler.this.onContentsChanged(slot);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)count);
        }

        public int getSlotLimit(int slot) {
            return ResizeBaseItemStackHandler.this.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }

    public static class Builder {
        private final int size;
        private int defaultSlotLimit = 64;
        private final Set<Integer> insertionOnlySlots = new HashSet<Integer>();
        private final Set<Integer> outputSlots = new HashSet<Integer>();
        private final Map<Integer, Integer> slotLimits = new HashMap<Integer, Integer>();
        private final Map<Integer, Predicate<ItemStack>> slotValidators = new HashMap<Integer, Predicate<ItemStack>>();
        private Consumer<Integer> contentsChanged = null;

        private Builder(int size) {
            this.size = size;
        }

        public Builder contentsChanged(Runnable action) {
            return this.contentsChanged((Integer slot) -> action.run());
        }

        public Builder contentsChanged(Consumer<Integer> action) {
            if (this.contentsChanged == null) {
                this.contentsChanged = action;
            } else {
                Consumer<Integer> old = this.contentsChanged;
                this.contentsChanged = slot -> {
                    old.accept((Integer)slot);
                    action.accept((Integer)slot);
                };
            }
            return this;
        }

        public Builder output(int ... slots) {
            int length = slots.length;
            for (int slot : slots) {
                this.outputSlots.add(slot);
            }
            return this;
        }

        public Builder output(Set<Integer> slots) {
            this.outputSlots.addAll(slots);
            return this;
        }

        public Builder output(Range<Integer> slots) {
            IntStream range = IntStream.range(0, this.size);
            Objects.requireNonNull(slots);
            range = range.filter(arg_0 -> slots.contains(arg_0));
            Set<Integer> integers = this.outputSlots;
            Objects.requireNonNull(integers);
            range.forEach(integers::add);
            return this;
        }

        public Builder insertionOnly(int ... slots) {
            int var3 = slots.length;
            for (int slot : slots) {
                this.insertionOnlySlots.add(slot);
            }
            return this;
        }

        public Builder insertionOnly(Set<Integer> slots) {
            this.insertionOnlySlots.addAll(slots);
            return this;
        }

        public Builder insertionOnly(Range<Integer> slots) {
            IntStream range = IntStream.range(0, this.size);
            Objects.requireNonNull(slots);
            range = range.filter(arg_0 -> slots.contains(arg_0));
            Set<Integer> integers = this.insertionOnlySlots;
            Objects.requireNonNull(integers);
            range.forEach(integers::add);
            return this;
        }

        public Builder defaultSlotLimit(int defaultSlotLimit) {
            this.defaultSlotLimit = defaultSlotLimit;
            return this;
        }

        public Builder slotLimit(int slotLimit, int ... slots) {
            int var4 = slots.length;
            for (int slot : slots) {
                this.slotLimits.put(slot, slotLimit);
            }
            return this;
        }

        public Builder slotLimit(int slotLimit, Set<Integer> slots) {
            for (int slot : slots) {
                this.slotLimits.put(slot, slotLimit);
            }
            return this;
        }

        public Builder slotLimit(int slotLimit, Range<Integer> slots) {
            IntStream range = IntStream.range(0, this.size);
            Objects.requireNonNull(slots);
            range.filter(arg_0 -> slots.contains(arg_0)).forEach(slot -> this.slotLimits.put(slot, slotLimit));
            return this;
        }

        public Builder validator(Predicate<ItemStack> validator, int ... slots) {
            for (int slot : slots) {
                this.slotValidators.put(slot, validator);
            }
            return this;
        }

        public Builder validator(Predicate<ItemStack> validator, Set<Integer> slots) {
            for (int slot : slots) {
                this.slotValidators.put(slot, validator);
            }
            return this;
        }

        public Builder validator(Predicate<ItemStack> validator, Range<Integer> slots) {
            IntStream range = IntStream.range(0, this.size);
            Objects.requireNonNull(slots);
            range.filter(arg_0 -> slots.contains(arg_0)).forEach(slot -> this.slotValidators.put(slot, validator));
            return this;
        }

        public ResizeBaseItemStackHandler build() {
            Stream stream = this.outputSlots.stream();
            Set<Integer> integers = this.insertionOnlySlots;
            Objects.requireNonNull(integers);
            if (stream.anyMatch(integers::contains)) {
                throw new IllegalStateException("Can't build ResizeBaseItemStackHandler: A slot can not be an insertion only and an output slot at the same time.");
            }
            return new ResizeBaseItemStackHandler(this.size, this.defaultSlotLimit, this.insertionOnlySlots, this.outputSlots, this.slotLimits, this.slotValidators, this.contentsChanged);
        }
    }
}

