/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.entities.manaSpark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.blocks.base.ExtraBotanicalTile;
import net.lmor.botanicalextramachinery.blocks.tiles.BlockEntityGreenhouse;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.SparkAugmentItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class EntityManaSparkPattern
extends SparkBaseEntity
implements ManaSpark {
    protected int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    private static final EntityDataAccessor<Integer> UPGRADE = SynchedEntityData.m_135353_(EntityManaSparkPattern.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final Set<ManaSpark> outgoingTransfers = Collections.newSetFromMap(new WeakHashMap());
    private final ArrayList<ManaSpark> transfersTowardsSelfToRegister = new ArrayList();
    private boolean shouldFilterTransfers = true;
    private boolean receiverWasFull = true;
    private boolean firstTick = true;

    public EntityManaSparkPattern(EntityType<?> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(UPGRADE, (Object)0);
    }

    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getSparkItem());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            SparkAttachable tile;
            if (this.firstTick) {
                this.updateTransfers();
            }
            if ((tile = this.getAttachedTile()) == null) {
                this.dropAndKill();
            } else {
                ManaReceiver receiver = this.getAttachedManaReceiver();
                SparkUpgradeType upgrade = this.getUpgrade();
                Collection<ManaSpark> transfers = this.getOutgoingTransfers();
                switch (upgrade) {
                    case DISPERSIVE: {
                        Player player2;
                        AABB aabb = VecHelper.boxForRange((Vec3)this.m_20182_().m_193103_(Direction.Axis.Y, this.m_20186_() + (double)this.m_20206_() / 2.0), (double)12.0);
                        List players = this.m_9236_().m_6443_(Player.class, aabb, EntitySelector.f_20402_);
                        HashMap receivingPlayers = new HashMap();
                        ItemStack input = new ItemStack((ItemLike)this.getSparkItem());
                        for (Player player2 : players) {
                            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                            stacks.addAll((Collection<ItemStack>)player2.m_150109_().f_35974_);
                            stacks.addAll((Collection<ItemStack>)player2.m_150109_().f_35975_);
                            Container inv = BotaniaAPI.instance().getAccessoriesInventory(player2);
                            for (int i = 0; i < inv.m_6643_(); ++i) {
                                stacks.add(inv.m_8020_(i));
                            }
                            for (ItemStack stack : stacks) {
                                HashMap<ManaItem, Integer> receivingStacks;
                                ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
                                if (stack.m_41619_() || manaItem == null || !manaItem.canReceiveManaFromItem(input)) continue;
                                boolean add = false;
                                if (!receivingPlayers.containsKey(player2)) {
                                    add = true;
                                    receivingStacks = new HashMap<ManaItem, Integer>();
                                } else {
                                    receivingStacks = (HashMap<ManaItem, Integer>)receivingPlayers.get(player2);
                                }
                                assert (receiver != null);
                                int recv = Math.min(receiver.getCurrentMana(), Math.min(this.TRANSFER_RATE, manaItem.getMaxMana() - manaItem.getMana()));
                                if (recv <= 0) continue;
                                receivingStacks.put(manaItem, recv);
                                if (!add) continue;
                                receivingPlayers.put(player2, receivingStacks);
                            }
                        }
                        if (receivingPlayers.isEmpty()) break;
                        ArrayList keys = new ArrayList(receivingPlayers.keySet());
                        Collections.shuffle(keys);
                        player2 = (Player)keys.iterator().next();
                        Map items = (Map)receivingPlayers.get(player2);
                        Map.Entry e = items.entrySet().iterator().next();
                        ManaItem manaItem = (ManaItem)e.getKey();
                        int cost = (Integer)e.getValue();
                        int manaToPut = Math.min(receiver.getCurrentMana(), cost);
                        manaItem.addMana(manaToPut);
                        receiver.receiveMana(-manaToPut);
                        this.particlesTowards((Entity)player2);
                        break;
                    }
                    case DOMINANT: {
                        if (this.receiverWasFull) {
                            assert (receiver != null);
                            if (!receiver.isFull()) {
                                this.updateTransfers();
                            }
                        }
                        if (this.transfersTowardsSelfToRegister.isEmpty()) break;
                        this.transfersTowardsSelfToRegister.remove(this.transfersTowardsSelfToRegister.size() - 1).registerTransfer((ManaSpark)this);
                        break;
                    }
                    default: {
                        if (!this.receiverWasFull) break;
                        assert (receiver != null);
                        if (receiver.isFull()) break;
                        this.notifyOthers(this.getNetwork());
                    }
                }
                this.receiverWasFull = receiver != null ? receiver.isFull() : true;
                if (!transfers.isEmpty()) {
                    assert (receiver != null);
                    int manaTotal = Math.min(this.TRANSFER_RATE * transfers.size(), receiver.getCurrentMana());
                    int count = transfers.size();
                    int manaSpent = 0;
                    if (manaTotal > 0) {
                        if (this.shouldFilterTransfers) {
                            this.filterTransfers();
                            this.shouldFilterTransfers = false;
                        }
                        for (ManaSpark spark : transfers) {
                            --count;
                            SparkAttachable attached = spark.getAttachedTile();
                            ManaReceiver attachedReceiver = spark.getAttachedManaReceiver();
                            if (!(attached == null || attachedReceiver == null || attachedReceiver.isFull() || spark.areIncomingTransfersDone() || receiver instanceof ExtraBotanicalTile && !(receiver instanceof BlockEntityGreenhouse) || attachedReceiver instanceof BlockEntityGreenhouse)) {
                                int spend = Math.min(attached.getAvailableSpaceForMana(), (manaTotal - manaSpent) / (count + 1));
                                attachedReceiver.receiveMana(spend);
                                manaSpent += spend;
                                this.particlesTowards(spark.entity());
                                continue;
                            }
                            this.shouldFilterTransfers = true;
                        }
                        receiver.receiveMana(-manaSpent);
                    }
                }
                this.firstTick = false;
            }
        }
    }

    public void updateTransfers() {
        this.transfersTowardsSelfToRegister.clear();
        switch (this.getUpgrade()) {
            case DOMINANT: {
                List otherSparks = SparkHelper.getSparksAround((Level)this.m_9236_(), (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (DyeColor)this.getNetwork());
                for (ManaSpark otherSpark : otherSparks) {
                    SparkUpgradeType otherUpgrade = otherSpark.getUpgrade();
                    if (otherSpark == this || otherUpgrade != SparkUpgradeType.NONE || !(otherSpark.getAttachedManaReceiver() instanceof ManaPool)) continue;
                    this.transfersTowardsSelfToRegister.add(otherSpark);
                }
                Collections.shuffle(this.transfersTowardsSelfToRegister);
                break;
            }
            case RECESSIVE: {
                List otherSparks = SparkHelper.getSparksAround((Level)this.m_9236_(), (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (DyeColor)this.getNetwork());
                Collections.shuffle(otherSparks);
                for (ManaSpark otherSpark : otherSparks) {
                    SparkUpgradeType otherUpgrade = otherSpark.getUpgrade();
                    if (otherSpark == this || otherUpgrade == SparkUpgradeType.DOMINANT || otherUpgrade == SparkUpgradeType.RECESSIVE || otherUpgrade == SparkUpgradeType.ISOLATED) continue;
                    this.outgoingTransfers.add(otherSpark);
                }
                break;
            }
        }
        this.filterTransfers();
    }

    private void particlesTowards(Entity e) {
        XplatAbstractions.INSTANCE.sendToTracking((Entity)this, (BotaniaPacket)new BotaniaEffectPacket(EffectType.SPARK_MANA_FLOW, this.m_20185_(), this.m_20186_(), this.m_20189_(), new int[]{this.m_19879_(), e.m_19879_(), ColorHelper.getColorValue((DyeColor)this.getNetwork())}));
    }

    public static void particleBeam(Player player, Entity e1, Entity e2) {
        if (e1 != null && e2 != null && !e1.m_9236_().f_46443_) {
            XplatAbstractions.INSTANCE.sendToPlayer(player, (BotaniaPacket)new BotaniaEffectPacket(EffectType.SPARK_NET_INDICATOR, e1.m_20185_(), e1.m_20186_(), e1.m_20189_(), new int[]{e1.m_19879_(), e2.m_19879_()}));
        }
    }

    protected Item getSparkItem() {
        return ModItems.malachiteSpark;
    }

    private void dropAndKill() {
        SparkUpgradeType upgrade = this.getUpgrade();
        this.m_5552_(new ItemStack((ItemLike)this.getSparkItem()), 0.0f);
        if (upgrade != SparkUpgradeType.NONE) {
            this.m_5552_(SparkAugmentItem.getByType((SparkUpgradeType)upgrade), 0.0f);
        }
        this.m_146870_();
    }

    public void m_142687_(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        this.notifyOthers(this.getNetwork());
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6084_() && !stack.m_41619_()) {
            DyeItem dye;
            DyeColor color;
            SparkUpgradeType upgrade = this.getUpgrade();
            if (stack.m_41720_() instanceof WandOfTheForestItem) {
                if (!this.m_9236_().f_46443_) {
                    if (player.m_6144_()) {
                        if (upgrade != SparkUpgradeType.NONE) {
                            this.m_5552_(SparkAugmentItem.getByType((SparkUpgradeType)upgrade), 0.0f);
                            this.setUpgrade(SparkUpgradeType.NONE);
                            this.outgoingTransfers.clear();
                            this.notifyOthers(this.getNetwork());
                        } else {
                            this.dropAndKill();
                        }
                    } else {
                        SparkHelper.getSparksAround((Level)this.m_9236_(), (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (DyeColor)this.getNetwork()).forEach(s -> EntityManaSparkPattern.particleBeam(player, (Entity)this, s.entity()));
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            Item item = stack.m_41720_();
            if (item instanceof SparkAugmentItem) {
                SparkAugmentItem newUpgrade = (SparkAugmentItem)item;
                if (upgrade == SparkUpgradeType.NONE) {
                    if (!this.m_9236_().f_46443_) {
                        this.setUpgrade(newUpgrade.type);
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
            if (stack.m_150930_(BotaniaItems.phantomInk)) {
                if (!this.m_9236_().f_46443_) {
                    this.m_6842_(true);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            item = stack.m_41720_();
            if (item instanceof DyeItem && (color = (dye = (DyeItem)item).m_41089_()) != this.getNetwork()) {
                if (!this.m_9236_().f_46443_) {
                    this.setNetwork(color);
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    protected void m_7378_(@NotNull CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setUpgrade(SparkUpgradeType.values()[cmp.m_128451_(TAG_UPGRADE)]);
    }

    protected void m_7380_(@NotNull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128405_(TAG_UPGRADE, this.getUpgrade().ordinal());
    }

    public SparkAttachable getAttachedTile() {
        return XplatAbstractions.INSTANCE.findSparkAttachable(this.m_9236_(), this.getAttachPos(), this.m_9236_().m_8055_(this.getAttachPos()), this.m_9236_().m_7702_(this.getAttachPos()), Direction.UP);
    }

    @Nullable
    public ManaReceiver getAttachedManaReceiver() {
        return XplatAbstractions.INSTANCE.findManaReceiver(this.m_9236_(), this.getAttachPos(), Direction.UP);
    }

    private void filterTransfers() {
        Iterator<ManaSpark> iter = this.outgoingTransfers.iterator();
        while (iter.hasNext()) {
            ManaSpark spark = iter.next();
            SparkUpgradeType upgr = this.getUpgrade();
            SparkUpgradeType supgr = spark.getUpgrade();
            ManaReceiver arecv = spark.getAttachedManaReceiver();
            if (spark != this && ((Entity)spark).m_6084_() && !spark.areIncomingTransfersDone() && this.getNetwork() == spark.getNetwork() && arecv != null && !arecv.isFull() && (upgr == SparkUpgradeType.NONE && supgr == SparkUpgradeType.DOMINANT || upgr == SparkUpgradeType.RECESSIVE && (supgr == SparkUpgradeType.NONE || supgr == SparkUpgradeType.DISPERSIVE) || !(arecv instanceof ManaPool))) continue;
            iter.remove();
        }
        return;
    }

    public Collection<ManaSpark> getOutgoingTransfers() {
        return this.outgoingTransfers;
    }

    private boolean hasTransfer(ManaSpark entity) {
        return this.outgoingTransfers.contains(entity);
    }

    public void registerTransfer(ManaSpark entity) {
        if (!this.hasTransfer(entity)) {
            this.outgoingTransfers.add(entity);
            this.filterTransfers();
        }
    }

    private void notifyOthers(DyeColor network) {
        for (ManaSpark spark : SparkHelper.getSparksAround((Level)this.m_9236_(), (double)this.m_20185_(), (double)(this.m_20186_() + (double)(this.m_20206_() / 2.0f)), (double)this.m_20189_(), (DyeColor)network)) {
            spark.updateTransfers();
        }
    }

    public SparkUpgradeType getUpgrade() {
        return SparkUpgradeType.values()[(Integer)this.f_19804_.m_135370_(UPGRADE)];
    }

    public void setUpgrade(SparkUpgradeType upgrade) {
        this.f_19804_.m_135381_(UPGRADE, (Object)upgrade.ordinal());
        this.updateTransfers();
        this.notifyOthers(this.getNetwork());
    }

    public void setNetwork(DyeColor color) {
        DyeColor previousNetwork = this.getNetwork();
        super.setNetwork(color);
        this.updateTransfers();
        this.notifyOthers(color);
        this.notifyOthers(previousNetwork);
    }

    public boolean areIncomingTransfersDone() {
        if (this.getAttachedManaReceiver() instanceof ManaPool) {
            return false;
        }
        SparkAttachable attachable = this.getAttachedTile();
        return attachable != null && attachable.areIncomingTranfersDone();
    }

    public record WandHud(EntityManaSparkPattern entity) implements WandHUD
    {
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack sparkStack = new ItemStack((ItemLike)this.entity.getSparkItem());
            ItemStack augmentStack = SparkAugmentItem.getByType((SparkUpgradeType)this.entity.getUpgrade());
            DyeColor networkColor = this.entity.getNetwork();
            String colorName = networkColor.m_41065_();
            MutableComponent networkColorName = Component.m_237115_((String)("color.minecraft." + colorName)).m_130940_(ChatFormatting.ITALIC);
            int textColor = ColorHelper.getColorLegibleOnGrayBackground((DyeColor)networkColor);
            int width = 4 + Collections.max(Arrays.asList(mc.f_91062_.m_92852_((FormattedText)networkColorName), RenderHelper.itemWithNameWidth((Minecraft)mc, (ItemStack)sparkStack), RenderHelper.itemWithNameWidth((Minecraft)mc, (ItemStack)augmentStack)));
            int height = augmentStack.m_41619_() ? 30 : 50;
            int networkColorTextStart = mc.f_91062_.m_92852_((FormattedText)networkColorName) / 2;
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            RenderHelper.renderHUDBox((GuiGraphics)gui, (int)(centerX - width / 2), (int)(centerY + 8), (int)(centerX + width / 2), (int)(centerY + 8 + height));
            RenderHelper.renderItemWithNameCentered((GuiGraphics)gui, (Minecraft)mc, (ItemStack)sparkStack, (int)(centerY + 10), (int)textColor);
            RenderHelper.renderItemWithNameCentered((GuiGraphics)gui, (Minecraft)mc, (ItemStack)augmentStack, (int)(centerY + 28), (int)textColor);
            gui.m_280430_(mc.f_91062_, (Component)networkColorName, centerX - networkColorTextStart, centerY + (augmentStack.m_41619_() ? 28 : 46), textColor);
        }
    }
}

