/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.tiles;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.lmor.botanicalextramachinery.Items.ItemUpgrade;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.blocks.base.ExtraBotanicalTile;
import net.lmor.botanicalextramachinery.blocks.flowersGreenhouse.GenFlowers;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.lmor.botanicalextramachinery.config.LibXServerConfig;
import net.lmor.botanicalextramachinery.util.ExportManaME;
import net.lmor.botanicalextramachinery.util.ResizeBaseItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import org.moddingx.libx.inventory.IAdvancedItemHandlerModifiable;
import vazkii.botania.client.fx.WispParticleData;

public class BlockEntityGreenhouse
extends ExtraBotanicalTile
implements IEnergyStorage,
IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    private static final int FLOWER_SIZE = 7;
    private static final int FUEL_SIZE = 21;
    private static final int UPGRADE_SIZE = 8;
    private int slotLimit = 1;
    private static final int baseManaStorage = LibXServerConfig.GreenhouseSettings.manaStorage;
    private static final int baseEnergyStorage = LibXServerConfig.GreenhouseSettings.energyCapacity;
    private boolean upgrade_cost_energy;
    private boolean upgrade_gen_mana;
    private boolean upgrade_heat;
    private static final float[] heatList = new float[]{1.05f, 1.1f, 1.15f, 1.2f};
    private int count_heat = 0;
    private static final int max_count_heat = 40;
    private boolean upgrade_slot_add;
    private float upgrade_speed_craft = 0.0f;
    private int energy = 0;
    private int energy_capacity;
    private final int energyTransfer;
    private final int energyCost;
    private final ResizeBaseItemStackHandler flowerInventory;
    private final BaseItemStackHandler fuelInventory;
    private final BaseItemStackHandler upgradeInventory;
    private final Map<Integer, ItemStack> flowerSlots = new HashMap<Integer, ItemStack>();
    private final Map<Integer, ItemStack> fuelSlots = new HashMap<Integer, ItemStack>();
    private static Map<Integer, List<ItemUpgrade>> availableUpgrade;
    private boolean fuelInventoryEmpty = false;
    private int greenhouseSleep;
    private static final boolean isModAppbot;
    private static final ExportManaME exportManaME;
    private boolean setChangedQueued = false;
    private final IManagedGridNode mainNode = ModList.get().isLoaded("appbot") ? this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy") : null;

    public BlockEntityGreenhouse(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state, baseManaStorage);
        this.energy_capacity = LibXServerConfig.GreenhouseSettings.energyCapacity;
        this.energyTransfer = LibXServerConfig.GreenhouseSettings.energyTransfer;
        this.energyCost = LibXServerConfig.GreenhouseSettings.energyCost;
        this.greenhouseSleep = LibXServerConfig.GreenhouseSettings.sleep;
        this.flowerInventory = ResizeBaseItemStackHandler.builder(7).validator(GenFlowers::isFlower, (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7))).slotLimit(this.getSlotLimit(), (Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7))).contentsChanged(slot -> {
            this.m_6596_();
            this.setDispatchable();
            this.flowerChanged((int)slot);
        }).build();
        this.fuelInventory = BaseItemStackHandler.builder((int)21).validator(this::isCheckFuelSlot, Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(7))).validator(stack -> this.upgrade_slot_add && this.isCheckFuelSlot((ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(21))).contentsChanged(slot -> {
            this.m_6596_();
            this.setDispatchable();
            this.fuelChanged((int)slot);
        }).build();
        this.upgradeInventory = BaseItemStackHandler.builder((int)8).validator(itemStack -> this.isCheckUpgradeSlot((ItemStack)itemStack, 0), new int[]{0}).validator(itemStack -> this.isCheckUpgradeSlot((ItemStack)itemStack, 1), new int[]{1}).validator(itemStack -> this.isCheckUpgradeSlot((ItemStack)itemStack, 2), new int[]{2}).validator(itemStack -> this.isCheckUpgradeSlot((ItemStack)itemStack, 3), new int[]{3}).validator(itemStack -> this.isCheckUpgradeSlot((ItemStack)itemStack, 4), new int[]{4}).validator(itemStack -> this.isCheckUpgradeSlot((ItemStack)itemStack, 5), new int[]{5}).validator(itemStack -> this.isCheckUpgradeSlot((ItemStack)itemStack, 6), new int[]{6}).validator(itemStack -> this.isCheckUpgradeSlot((ItemStack)itemStack, 7), new int[]{7}).defaultSlotLimit(1).contentsChanged(slot -> {
            this.m_6596_();
            this.setDispatchable();
            this.updateUpgradeSlot((int)slot);
        }).build();
        BlockEntityGreenhouse.upgrade();
    }

    public int getCountHeat() {
        return this.count_heat;
    }

    public int getMaxCountHeat() {
        return 40;
    }

    public void updateUpgradeSlot(int slot) {
        if (this.upgradeInventory.getStackInSlot(slot).m_41619_()) {
            switch (slot) {
                case 0: {
                    this.flowerInventory.setSlotLimits(1);
                    this.slotLimit = 1;
                    this.dropLimitFlowers();
                    break;
                }
                case 1: {
                    this.upgrade_gen_mana = false;
                    break;
                }
                case 2: {
                    this.upgrade_slot_add = false;
                    break;
                }
                case 3: {
                    this.upgrade_cost_energy = false;
                    break;
                }
                case 4: {
                    this.upgrade_speed_craft = 0.0f;
                    this.greenhouseSleep = Math.min(this.greenhouseSleep, LibXServerConfig.GreenhouseSettings.sleep);
                    break;
                }
                case 5: {
                    this.setMaxEnergyStored(baseEnergyStorage);
                    this.setEnergyStored(Math.min(this.getEnergyStored(), baseEnergyStorage));
                    break;
                }
                case 6: {
                    this.setMaxMana(baseManaStorage);
                    this.setCurrentMana(Math.min(this.getCurrentMana(), baseManaStorage));
                    break;
                }
                case 7: {
                    this.count_heat = 0;
                    this.upgrade_heat = false;
                }
            }
        } else {
            boolean stop = false;
            for (ItemUpgrade item : this.getUpgradeSlot(slot)) {
                if (this.upgradeInventory.getStackInSlot(slot).m_41720_() == item) {
                    switch (slot) {
                        case 0: {
                            this.slotLimit = item.getValueItem();
                            this.flowerInventory.setSlotLimits(this.slotLimit);
                            this.dropLimitFlowers();
                            stop = true;
                            break;
                        }
                        case 1: {
                            this.upgrade_gen_mana = true;
                            stop = true;
                            break;
                        }
                        case 2: {
                            this.upgrade_slot_add = true;
                            stop = true;
                            break;
                        }
                        case 3: {
                            this.upgrade_cost_energy = true;
                            stop = true;
                            break;
                        }
                        case 4: {
                            if (this.upgradeInventory.getStackInSlot(slot).m_41720_() == ModItems.upgradeTickGenMana_1) {
                                this.upgrade_speed_craft = (float)ModItems.upgradeTickGenMana_1.getValueItem() / 100.0f;
                            } else if (this.upgradeInventory.getStackInSlot(slot).m_41720_() == ModItems.upgradeTickGenMana_2) {
                                this.upgrade_speed_craft = (float)ModItems.upgradeTickGenMana_2.getValueItem() / 100.0f;
                            }
                            stop = true;
                            break;
                        }
                        case 5: {
                            this.setMaxEnergyStored(Math.min(baseEnergyStorage * item.getValueItem(), Integer.MAX_VALUE));
                            this.setEnergyStored(Math.min(this.getEnergyStored(), this.getMaxEnergyStored()));
                            stop = true;
                            break;
                        }
                        case 6: {
                            this.setMaxMana(Math.min(baseManaStorage * item.getValueItem(), Integer.MAX_VALUE));
                            this.setCurrentMana(Math.min(this.getCurrentMana(), this.getMaxMana()));
                            stop = true;
                            break;
                        }
                        case 7: {
                            this.upgrade_heat = true;
                        }
                    }
                }
                if (!stop) continue;
                break;
            }
        }
        this.m_6596_();
        this.setDispatchable();
    }

    private int getSlotLimit() {
        return this.slotLimit;
    }

    public static void upgrade() {
        availableUpgrade = new HashMap<Integer, List<ItemUpgrade>>();
        ArrayList<ItemUpgrade> upg = new ArrayList<ItemUpgrade>();
        upg.add(ModItems.upgradeFlower_4x);
        upg.add(ModItems.upgradeFlower_16x);
        upg.add(ModItems.upgradeFlower_32x);
        upg.add(ModItems.upgradeFlower_64x);
        availableUpgrade.put(0, upg);
        upg = new ArrayList();
        upg.add(ModItems.upgradeGenMana);
        availableUpgrade.put(1, upg);
        upg = new ArrayList();
        upg.add(ModItems.upgradeSlotAdd);
        availableUpgrade.put(2, upg);
        upg = new ArrayList();
        upg.add(ModItems.upgradeCostEnergy);
        availableUpgrade.put(3, upg);
        upg = new ArrayList();
        upg.add(ModItems.upgradeTickGenMana_1);
        upg.add(ModItems.upgradeTickGenMana_2);
        availableUpgrade.put(4, upg);
        upg = new ArrayList();
        upg.add(ModItems.upgradeStorageEnergy_1);
        upg.add(ModItems.upgradeStorageEnergy_2);
        upg.add(ModItems.upgradeStorageEnergy_3);
        availableUpgrade.put(5, upg);
        upg = new ArrayList();
        upg.add(ModItems.upgradeStorageMana_1);
        upg.add(ModItems.upgradeStorageMana_2);
        upg.add(ModItems.upgradeStorageMana_3);
        availableUpgrade.put(6, upg);
        upg = new ArrayList();
        upg.add(ModItems.upgradeHeatGreenhouse);
        availableUpgrade.put(7, upg);
    }

    public List<ItemUpgrade> getUpgradeSlot(int slot) {
        return availableUpgrade.get(slot);
    }

    public boolean isCheckUpgradeSlot(ItemStack itemStack, int slot) {
        if (itemStack.m_41619_()) {
            return false;
        }
        for (Item item : availableUpgrade.get(slot)) {
            if (item != itemStack.m_41720_()) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckFuelSlot(ItemStack fuel) {
        for (Integer slot : this.flowerSlots.keySet()) {
            if (!GenFlowers.availableFuelItem(this.getFlowerInventory().getStackInSlot(slot), fuel)) continue;
            return true;
        }
        return false;
    }

    public void reloadFuelSlots() {
        if (this.flowerSlots.size() == 0) {
            for (int slotFlower = 0; slotFlower < this.getFlowerInventory().getSlots(); ++slotFlower) {
                this.flowerChanged(slotFlower);
            }
        }
    }

    public void flowerChanged(int slot) {
        if (!this.flowerInventory.getStackInSlot(slot).m_41619_()) {
            ItemStack itemStack = this.flowerInventory.getStackInSlot(slot);
            this.flowerSlots.put(slot, itemStack);
        } else {
            this.flowerSlots.remove(slot);
        }
    }

    public void fuelChanged(int slot) {
        if (!this.fuelInventory.getStackInSlot(slot).m_41619_()) {
            ItemStack itemStack = this.fuelInventory.getStackInSlot(slot);
            this.fuelSlots.put(slot, itemStack);
        } else {
            this.fuelSlots.remove(slot);
        }
    }

    @Override
    @NotNull
    public <X> LazyOptional<X> getCapability(@NotNull Capability<X> cap, Direction direction) {
        if (cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, direction);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.getMainNode() != null && !this.getMainNode().isReady()) {
                this.getMainNode().create(this.f_58857_, this.m_58899_());
            }
            if (this.greenhouseSleep <= 0) {
                this.greenhouseSleep = this.upgrade_speed_craft != 0.0f ? (int)((float)LibXServerConfig.GreenhouseSettings.sleep - (float)LibXServerConfig.GreenhouseSettings.sleep * this.upgrade_speed_craft) : LibXServerConfig.GreenhouseSettings.sleep;
            }
            --this.greenhouseSleep;
            if (this.getMaxMana() == this.getCurrentMana() || this.getEnergyStored() < this.energyCost || this.fuelSlots.size() == 0) {
                if (this.count_heat > 0 && this.greenhouseSleep <= 0) {
                    --this.count_heat;
                    this.m_6596_();
                    this.setDispatchable();
                }
                return;
            }
            if (this.greenhouseSleep <= 0) {
                boolean craft = false;
                for (Integer flowerSlot : this.flowerSlots.keySet()) {
                    ItemStack flower = this.flowerSlots.get(flowerSlot);
                    ArrayList<Object> a = this.getFuelSlot(flower);
                    if (a.size() != 2 || a.get(0) == null || (Integer)a.get(1) <= -1) continue;
                    GenFlowers genFlowers = (GenFlowers)a.get(0);
                    int fSlot = (Integer)a.get(1);
                    int[] b = this.receiveManaCraft(genFlowers, flower.m_41613_(), this.fuelInventory.getStackInSlot(fSlot).m_41777_());
                    if (b == null) continue;
                    int addMana = b[0];
                    int fuelExtract = b[1];
                    int removeEnergy = b[2];
                    IAdvancedItemHandlerModifiable inventory = this.fuelInventory.getUnrestricted();
                    inventory.extractItem(fSlot, fuelExtract, false);
                    this.receiveMana(addMana);
                    this.receiveEnergy(-removeEnergy, false);
                    craft = true;
                }
                if (isModAppbot && exportManaME != null && this.getMainNode() != null && this.getMainNode().getNode() != null && this.getMainNode().isOnline()) {
                    this.receiveMana(exportManaME.exportManaME(this.getCurrentMana(), this.getMainNode().getNode().getGrid()));
                }
                if (craft && this.upgrade_heat) {
                    this.count_heat = Math.min(this.count_heat + 1, 40);
                } else if (this.upgrade_heat) {
                    this.count_heat = Math.max(this.count_heat - 1, 0);
                }
                this.m_6596_();
                this.setDispatchable();
            }
        } else if (LibXClientConfig.RenderingVisualContent.all && LibXClientConfig.RenderingVisualContent.greenhouse) {
            double particleChance = (double)this.getCurrentMana() / (double)this.getMaxMana() * 0.1;
            if (Math.random() < particleChance) {
                float red = 0.0f;
                float green = 0.7764706f;
                float blue = 1.0f;
                for (int i = 0; i < 2; ++i) {
                    WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)red, (float)green, (float)blue, (float)2.0f);
                    this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.m_188500_() * 0.4, (double)this.f_58858_.m_123342_() + 0.5 + this.f_58857_.f_46441_.m_188500_() * 0.25, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.m_188500_() * 0.4, 0.0, (double)(this.f_58857_.f_46441_.m_188501_() / 25.0f), 0.0);
                }
            }
        }
    }

    private ArrayList<Object> getFuelSlot(ItemStack flower) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Integer fuelSlot : this.fuelSlots.keySet()) {
            if (!GenFlowers.availableFuelItem(flower, this.fuelSlots.get(fuelSlot))) continue;
            res.add(GenFlowers.getFlowerIsFuel(flower, this.fuelSlots.get(fuelSlot)));
            res.add(fuelSlot);
            break;
        }
        return res;
    }

    private int[] receiveManaCraft(GenFlowers genFlowers, int flower, ItemStack fuel) {
        int countFlower = flower;
        int maxMana = this.getMaxMana() - this.getCurrentMana();
        int manaInFlowers = genFlowers.getPerMana(fuel);
        while (true) {
            if (!((double)maxMana < (double)(manaInFlowers * countFlower) * (this.upgrade_gen_mana ? 1.25 : 1.0) * (double)(this.count_heat <= 40 && this.count_heat >= 10 ? heatList[this.count_heat / 10 - 1] : 1.0f))) {
                float f = this.getEnergyStored();
                float f2 = this.energyCost * countFlower * (this.upgrade_gen_mana ? 2 : 1);
                float f3 = this.upgrade_cost_energy ? 0.5f : 1.0f;
                if (!(f < f2 * f3)) break;
            }
            --countFlower;
        }
        if (countFlower == 0) {
            return null;
        }
        int fuelCountExtract = Math.min(countFlower, fuel.m_41613_());
        int addMana = (int)((float)(manaInFlowers * fuelCountExtract) * (this.upgrade_gen_mana ? 1.25f : 1.0f) * (this.count_heat <= 40 && this.count_heat >= 10 ? heatList[this.count_heat / 10 - 1] : 1.0f));
        int removeEnergy = (int)((float)(this.energyCost * fuelCountExtract * (this.upgrade_gen_mana ? 2 : 1)) * (this.upgrade_cost_energy ? 0.5f : 1.0f));
        return new int[]{addMana, fuelCountExtract, removeEnergy};
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> supplier) {
        return slot -> false;
    }

    @Override
    @NotNull
    public BaseItemStackHandler getInventory() {
        return this.fuelInventory;
    }

    public ResizeBaseItemStackHandler getFlowerInventory() {
        return this.flowerInventory;
    }

    public BaseItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public int getComparatorOutput() {
        return 0;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        int i;
        super.m_142466_(nbt);
        this.getFlowerInventory().deserializeNBT(nbt.m_128469_("invFlower"));
        this.getUpgradeInventory().deserializeNBT(nbt.m_128469_("invUpgrade"));
        this.fuelInventoryEmpty = nbt.m_128471_("fuelInventoryEmpty");
        this.energy = nbt.m_128451_("energyStorage");
        this.energy_capacity = nbt.m_128451_("energyCapacity");
        this.count_heat = nbt.m_128451_("countHeat");
        if (this.getMainNode() != null) {
            this.getMainNode().loadFromNBT(nbt);
        }
        this.reloadFuelSlots();
        for (i = 0; i < this.getUpgradeInventory().getSlots(); ++i) {
            this.updateUpgradeSlot(i);
        }
        for (i = 0; i < this.getInventory().getSlots(); ++i) {
            this.fuelChanged(i);
        }
        this.m_6596_();
        this.setDispatchable();
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("invFlower", (Tag)this.getFlowerInventory().serializeNBT());
        nbt.m_128365_("invUpgrade", (Tag)this.getUpgradeInventory().serializeNBT());
        nbt.m_128379_("fuelInventoryEmpty", this.fuelInventoryEmpty);
        nbt.m_128405_("energyStorage", this.energy);
        nbt.m_128405_("energyCapacity", this.energy_capacity);
        nbt.m_128405_("countHeat", this.count_heat);
        if (this.getMainNode() != null) {
            this.getMainNode().saveToNBT(nbt);
        }
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.getFlowerInventory().deserializeNBT(nbt.m_128469_("invFlower"));
            this.getUpgradeInventory().deserializeNBT(nbt.m_128469_("invUpgrade"));
            this.fuelInventoryEmpty = nbt.m_128471_("fuelInventoryEmpty");
            this.energy = nbt.m_128451_("energyStorage");
            this.energy_capacity = nbt.m_128451_("energyCapacity");
            this.count_heat = nbt.m_128451_("countHeat");
            for (int i = 0; i < this.getUpgradeInventory().getSlots(); ++i) {
                this.updateUpgradeSlot(i);
            }
        }
    }

    @Override
    @NotNull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("invFlower", (Tag)this.getFlowerInventory().serializeNBT());
        nbt.m_128365_("invUpgrade", (Tag)this.getUpgradeInventory().serializeNBT());
        nbt.m_128379_("fuelInventoryEmpty", this.fuelInventoryEmpty);
        nbt.m_128405_("energyStorage", this.energy);
        nbt.m_128405_("energyCapacity", this.energy_capacity);
        nbt.m_128405_("countHeat", this.count_heat);
        return nbt;
    }

    public void drops() {
        ItemEntity ie;
        ItemStack itemStack;
        int i;
        if (this.f_58857_ == null) {
            return;
        }
        IAdvancedItemHandlerModifiable inventoryUpgrade = this.getUpgradeInventory().getUnrestricted();
        IAdvancedItemHandlerModifiable inventoryFlower = this.getFlowerInventory().getUnrestricted();
        for (i = 0; i < inventoryUpgrade.getSlots(); ++i) {
            itemStack = inventoryUpgrade.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
        for (i = 0; i < inventoryFlower.getSlots(); ++i) {
            itemStack = inventoryFlower.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack.m_41777_());
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    private void dropLimitFlowers() {
        if (this.f_58857_ == null) {
            return;
        }
        IAdvancedItemHandlerModifiable inventoryFlower = this.getFlowerInventory().getUnrestricted();
        for (int i = 0; i < this.flowerInventory.getSlots(); ++i) {
            ItemStack itemStack = inventoryFlower.getStackInSlot(i).m_41777_();
            if (itemStack.m_41619_()) continue;
            itemStack.m_41764_(itemStack.m_41613_() - this.slotLimit);
            inventoryFlower.extractItem(i, itemStack.m_41613_(), false);
            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.7, (double)this.f_58858_.m_123343_() + 0.5, itemStack);
            this.f_58857_.m_7967_((Entity)ie);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getMainNode() != null) {
            this.getMainNode().destroy();
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        if (maxReceive >= 0 && this.getMaxEnergyStored() == this.getEnergyStored()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(this.energyTransfer, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        this.m_6596_();
        this.setDispatchable();
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.energy_capacity;
    }

    private void setEnergyStored(int val) {
        this.energy = val;
    }

    private void setMaxEnergyStored(int val) {
        this.energy_capacity = val;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.energyTransfer > 0;
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected Item getItemFromBlockEntity() {
        return ModBlocks.greenhouse.m_5456_();
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        if (this.getMainNode() == null) {
            return null;
        }
        return this.getMainNode().getNode();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void saveChanges() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.m_6596_();
            } else {
                this.f_58857_.m_151543_(this.f_58858_);
                if (!this.setChangedQueued) {
                    TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                    this.setChangedQueued = true;
                }
            }
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    static {
        isModAppbot = ModList.get().isLoaded("appbot");
        exportManaME = ModList.get().isLoaded("appbot") ? new ExportManaME() : null;
    }
}

