/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.tesr;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lmor.botanicalextramachinery.blocks.tiles.BlockEntityGreenhouse;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RenderGreenhouse
implements BlockEntityRenderer<BlockEntityGreenhouse> {
    BakedModel pylonsModel = Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("botanicalextramachinery", "block/greenhouse/pylons"));
    BakedModel[] circleModels = new BakedModel[]{Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("botanicalextramachinery", "block/greenhouse/circle_3")), Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("botanicalextramachinery", "block/greenhouse/circle_2")), Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("botanicalextramachinery", "block/greenhouse/circle_1"))};
    BakedModel gardenBedModel = Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("botanicalextramachinery", "block/greenhouse/garden_bed"));

    private void renderState(@Nullable BlockState state, float translateX, float translateZ, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (state != null) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)translateX, 0.0, (double)translateZ);
            Minecraft.m_91087_().m_91289_().m_110912_(state, poseStack, buffer, light, overlay);
            poseStack.m_85849_();
        }
    }

    public void render(BlockEntityGreenhouse blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        float angle = ((float)blockEntity.m_58904_().m_46467_() + partialTick) % 360.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(angle));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110792_()), null, this.pylonsModel, 1.0f, 1.0f, 1.0f, light, overlay);
        poseStack.m_85849_();
        float[] y_offset = new float[]{0.017f, 0.025f, 0.06f};
        for (int i = 0; i < 3; ++i) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.1 - (double)i * 0.01, 0.5);
            angle = ((float)blockEntity.m_58904_().m_46467_() + partialTick) % 360.0f;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(i == 1 ? -angle : angle));
            double phaseShift = (double)i * 1.5707963267948966;
            double bounce = Math.sin((double)((float)blockEntity.m_58904_().m_46467_() + partialTick) * 0.05 + phaseShift) * (double)0.083f - (double)y_offset[i];
            poseStack.m_85837_(-0.5, bounce, -0.5);
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), blockEntity.m_58900_(), this.circleModels[i], 1.0f, 1.0f, 1.0f, light, overlay);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.05, 0.5);
        angle = ((float)blockEntity.m_58904_().m_46467_() + partialTick) % 360.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-angle));
        double bounce = Math.sin((double)((float)blockEntity.m_58904_().m_46467_() + partialTick) * 0.1) * 0.02;
        poseStack.m_85837_(-0.5, bounce, -0.5);
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110792_()), blockEntity.m_58900_(), this.gardenBedModel, 1.0f, 1.0f, 1.0f, light, overlay);
        poseStack.m_85849_();
        for (int i = 0; i < blockEntity.getFlowerInventory().getSlots(); ++i) {
            ItemStack flowerStack;
            Item item;
            if (blockEntity.getFlowerInventory().getStackInSlot(i).m_41619_() || !((item = (flowerStack = blockEntity.getFlowerInventory().getStackInSlot(i)).m_41720_()) instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            Block flowerBlock = blockItem.m_40614_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.4, 0.485 + bounce, 0.4);
            poseStack.m_85841_(0.2f, 0.2f, 0.2f);
            double flowerOffsetX = Math.cos((double)i * Math.PI * 2.0 / (double)blockEntity.getFlowerInventory().getSlots()) * 0.7;
            double flowerOffsetZ = Math.sin((double)i * Math.PI * 2.0 / (double)blockEntity.getFlowerInventory().getSlots()) * 0.7;
            poseStack.m_85837_(flowerOffsetX, 0.0, flowerOffsetZ);
            Minecraft.m_91087_().m_91289_().m_110912_(flowerBlock.m_49966_(), poseStack, buffer, light, overlay);
            poseStack.m_85849_();
        }
    }
}

