/*
 * Decompiled with CFR 0.152.
 */
package appbot.item.cell;

import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appbot.item.cell.IManaCellItem;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.core.definitions.AEItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ManaCellInventory
implements StorageCell {
    private static final String AMOUNT = "amount";
    private final IManaCellItem cellType;
    private final ItemStack i;
    @Nullable
    private final ISaveProvider container;
    private final boolean hasVoidUpgrade;
    private long storedMana;
    private boolean isPersisted = true;

    public ManaCellInventory(IManaCellItem cellType, ItemStack o, @Nullable ISaveProvider container) {
        this.cellType = cellType;
        this.i = o;
        this.container = container;
        this.storedMana = this.getTag().m_128454_(AMOUNT);
        this.hasVoidUpgrade = cellType.getUpgrades(o).isInstalled((ItemLike)AEItems.VOID_CARD);
    }

    private CompoundTag getTag() {
        return this.i.m_41784_();
    }

    public CellState getStatus() {
        if (this.storedMana == 0L) {
            return CellState.EMPTY;
        }
        if (this.storedMana == this.getMaxMana()) {
            return CellState.FULL;
        }
        if (this.storedMana > this.getMaxMana() / 2L) {
            return CellState.TYPES_FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    private long getMaxMana() {
        return this.cellType.getTotalBytes() * (long)ManaKeyType.TYPE.getAmountPerByte();
    }

    protected long getTotalBytes() {
        return this.cellType.getTotalBytes();
    }

    protected long getUsedBytes() {
        int amountPerByte = ManaKeyType.TYPE.getAmountPerByte();
        return (this.storedMana + (long)amountPerByte - 1L) / (long)amountPerByte;
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        long inserted = Math.min(this.getMaxMana() - this.storedMana, amount);
        if (mode == Actionable.MODULATE) {
            this.storedMana += inserted;
            this.saveChanges();
        }
        return this.hasVoidUpgrade ? amount : inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        long extracted = Math.min(this.storedMana, amount);
        if (mode == Actionable.MODULATE) {
            this.storedMana -= extracted;
            this.saveChanges();
        }
        return extracted;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.storedMana <= 0L) {
            this.getTag().m_128473_(AMOUNT);
        } else {
            this.getTag().m_128356_(AMOUNT, this.storedMana);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.storedMana > 0L) {
            out.add(ManaKey.KEY, this.storedMana);
        }
    }

    public Component getDescription() {
        return this.i.m_41786_();
    }
}

