/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CurtainBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HorizontalConnectionType> HORIZONTAL_CONNECTION_TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty VERTICAL_CONNECTION_TYPE = ModBlockStateProperties.VERTICAL_CONNECTION_TYPE_UP_DOWN;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public CurtainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HORIZONTAL_CONNECTION_TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_((Property)VERTICAL_CONNECTION_TYPE, (Comparable)Direction.UP)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        HorizontalConnectionType type = (HorizontalConnectionType)((Object)state.m_61143_(HORIZONTAL_CONNECTION_TYPE));
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && (type == HorizontalConnectionType.SINGLE || type == HorizontalConnectionType.MIDDLE) && state.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == Direction.DOWN) {
            return Shapes.m_83040_();
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? Shapes.m_83040_() : super.m_5939_(state, level, pos, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean sideR;
        Direction clickedFacingFace;
        Direction clickedFace;
        BlockPos pos;
        Level level = context.m_43725_();
        if (!level.m_8055_((pos = context.m_8083_()).m_7495_()).m_60629_(context) || level.m_151570_(pos.m_7495_())) {
            return null;
        }
        Direction facing = context.m_43719_();
        BlockPos clickedPos = context.m_8083_();
        BlockPos clickedFacingPos = clickedPos.m_121945_(clickedFace = context.m_43719_());
        BlockState clickedFacingState = level.m_8055_(clickedFacingPos);
        if (clickedFacingState.m_60734_() instanceof CurtainBlock && (clickedFacingFace = (Direction)clickedFacingState.m_61143_((Property)FACING)) != clickedFace && clickedFacingFace.m_122424_() != clickedFace) {
            facing = clickedFacingFace;
        }
        if (facing.m_122434_().m_122478_()) {
            facing = context.m_8125_().m_122424_();
        }
        BlockState stateL = level.m_8055_(pos.m_121945_(facing.m_122427_()));
        BlockState stateR = level.m_8055_(pos.m_121945_(facing.m_122428_()));
        boolean sideL = stateL.m_60734_() instanceof CurtainBlock && stateL.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP && stateL.m_61143_((Property)FACING) == facing;
        boolean bl = sideR = stateR.m_60734_() instanceof CurtainBlock && stateR.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP && stateR.m_61143_((Property)FACING) == facing;
        boolean open = sideL && sideR ? ((Boolean)stateL.m_61143_((Property)OPEN)).booleanValue() || ((Boolean)stateR.m_61143_((Property)OPEN)).booleanValue() : (sideR ? (Boolean)stateR.m_61143_((Property)OPEN) : (sideL ? (Boolean)stateL.m_61143_((Property)OPEN) : true));
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_) {
            return;
        }
        BlockPos blockPos = pos.m_7495_();
        level.m_7731_(blockPos, (BlockState)((BlockState)state.m_61124_((Property)VERTICAL_CONNECTION_TYPE, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockPos).m_76152_() == Fluids.f_76193_)), 3);
        level.m_6289_(pos, Blocks.f_50016_);
        state.m_60701_((LevelAccessor)level, pos, 3);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean sideR;
        BlockState stateOpposite;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction facing_vertical = (Direction)state.m_61143_((Property)VERTICAL_CONNECTION_TYPE);
        if (direction.m_122434_().m_122478_() && (!((stateOpposite = level.m_8055_(currentPos.m_121945_(facing_vertical.m_122424_()))).m_60734_() instanceof CurtainBlock) || stateOpposite.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == facing_vertical)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction != facing.m_122427_() && direction != facing.m_122428_()) {
            return state;
        }
        BlockState stateL = level.m_8055_(currentPos.m_121945_(facing.m_122427_()));
        BlockState stateR = level.m_8055_(currentPos.m_121945_(facing.m_122428_()));
        boolean sideL = stateL.m_60734_() instanceof CurtainBlock && stateL.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == facing_vertical && stateL.m_61143_((Property)FACING) == facing;
        boolean bl = sideR = stateR.m_60734_() instanceof CurtainBlock && stateR.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == facing_vertical && stateR.m_61143_((Property)FACING) == facing;
        HorizontalConnectionType type = sideL && sideR ? HorizontalConnectionType.MIDDLE : (sideR ? HorizontalConnectionType.LEFT : (sideL ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.m_61124_(HORIZONTAL_CONNECTION_TYPE, (Comparable)((Object)type));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (state.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == Direction.UP) {
            this.toggleFromTop(state, level, pos);
        } else {
            this.toggleFromTop(level.m_8055_(pos.m_7494_()), level, pos.m_7494_());
        }
        level.m_5594_(null, pos, AFSoundEvents.CURTAIN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void toggleFromTop(BlockState state, Level level, BlockPos pos) {
        boolean open = (Boolean)state.m_61143_((Property)OPEN) == false;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction relativeLeft = facing.m_122427_();
        Direction relativeRight = facing.m_122428_();
        this.toggleVertical(state, level, pos, open);
        this.toggleHorizontal(state, level, pos, open, facing, relativeLeft);
        this.toggleHorizontal(state, level, pos, open, facing, relativeRight);
    }

    public void toggleHorizontal(BlockState state, Level level, BlockPos pos, boolean open, Direction facing, Direction dir) {
        BlockPos facingHorizontalPos = pos.m_121945_(dir);
        BlockState facingHorizontalState = level.m_8055_(facingHorizontalPos);
        if (facingHorizontalState.m_60734_() instanceof CurtainBlock && facingHorizontalState.m_61143_((Property)FACING) == facing && state.m_61143_((Property)VERTICAL_CONNECTION_TYPE) == facingHorizontalState.m_61143_((Property)VERTICAL_CONNECTION_TYPE)) {
            this.toggleVertical(facingHorizontalState, level, facingHorizontalPos, open);
            this.toggleHorizontal(facingHorizontalState, level, facingHorizontalPos, open, facing, dir);
        }
    }

    public void toggleVertical(BlockState state, Level level, BlockPos pos, boolean open) {
        Direction facingVertical = (Direction)state.m_61143_((Property)VERTICAL_CONNECTION_TYPE);
        BlockPos facingVerticalPos = pos.m_121945_(facingVertical.m_122424_());
        BlockState facingVerticalState = level.m_8055_(facingVerticalPos);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        if (facingVerticalState.m_60734_() instanceof CurtainBlock && facingVertical == ((Direction)facingVerticalState.m_61143_((Property)VERTICAL_CONNECTION_TYPE)).m_122424_()) {
            level.m_46597_(facingVerticalPos, (BlockState)facingVerticalState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HORIZONTAL_CONNECTION_TYPE, OPEN, VERTICAL_CONNECTION_TYPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

