/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.search.method.InputMethod;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.hints.HintProvider;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.widget.CraftableFilterButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.client.search.method.DefaultInputMethod;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class InputMethodWatcher
implements HintProvider {
    @Override
    public List<Component> provide() {
        if (PluginManager.areAnyReloading() || OverlaySearchField.isHighlighting) {
            return Collections.emptyList();
        }
        ResourceLocation id = ConfigObject.getInstance().getInputMethodId();
        if (id == null) {
            String languageCode = Minecraft.m_91087_().f_91066_.f_92075_;
            MutableComponent component = Component.m_237119_();
            int match = 0;
            for (InputMethod<?> method : InputMethodRegistry.getInstance().getAll().values()) {
                if (method instanceof DefaultInputMethod || !CollectionUtils.anyMatch(method.getMatchingLocales(), locale -> locale.code().equals(languageCode))) continue;
                if (!component.getString().isEmpty()) {
                    component.m_130946_(", ");
                }
                component.m_7220_(method.getName());
                ++match;
            }
            if (match > 0) {
                return List.of(Component.m_237115_((String)"text.rei.input.methods.hint"), Component.m_237113_((String)" "), component);
            }
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public Tooltip provideTooltip(Point mouse) {
        return null;
    }

    @Override
    public Color getColor() {
        return Color.ofTransparent((int)-21046);
    }

    @Override
    public List<HintProvider.HintButton> getButtons() {
        return List.of(new HintProvider.HintButton((Component)Component.m_237115_((String)"text.rei.hint.configure"), bounds -> {
            MenuAccess access = ScreenOverlayImpl.getInstance().menuAccess();
            access.openOrClose(CraftableFilterButtonWidget.FILTER_MENU_UUID, bounds.clone(), () -> CraftableFilterButtonWidget.createInputMethodEntries(access, CraftableFilterButtonWidget.getApplicableInputMethods()));
        }), new HintProvider.HintButton((Component)Component.m_237115_((String)"text.rei.hint.ignore"), bounds -> {
            ConfigManagerImpl.getInstance().getConfig().setInputMethodId(new ResourceLocation("rei:default"));
            ConfigManager.getInstance().saveConfig();
        }));
    }
}

