/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.GameType;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class GameModeFavoriteEntry
extends FavoriteEntry {
    public static final ResourceLocation ID = new ResourceLocation("roughlyenoughitems", "gamemode");
    public static final String TRANSLATION_KEY = "favorite.section.gamemode";
    public static final String KEY = "mode";
    @Nullable
    private final GameType gameMode;

    public GameModeFavoriteEntry(@Nullable GameType gameMode) {
        this.gameMode = gameMode;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public Renderer getRenderer(boolean showcase) {
        if (this.gameMode == null) {
            List renderers = IntStream.range(0, 4).mapToObj(GameModeFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(showcase, renderers, () -> Minecraft.m_91087_().f_91072_.m_105295_().m_46392_()){

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create(context.getPoint(), new Component[]{Component.m_237115_((String)"text.rei.gamemode_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(this.getClass(), this.showcase);
                }
            };
        }
        return GameModeFavoriteEntry.getRenderer(this.gameMode.m_46392_());
    }

    private static Renderer getRenderer(int id) {
        final GameType type = GameType.m_46393_((int)id);
        return new Renderer(){

            @Override
            public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_((float)bounds.getCenterX(), (float)bounds.getCenterY(), 0.0f);
                    graphics.m_280168_().m_85841_((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f, 1.0f);
                    this.renderGameModeText(graphics, type, 0, 0, color);
                    graphics.m_280168_().m_85849_();
                }
            }

            private void renderGameModeText(GuiGraphics graphics, GameType type2, int centerX, int centerY, int color) {
                MutableComponent s = Component.m_237115_((String)("text.rei.short_gamemode." + type2.m_46405_()));
                Font font = Minecraft.m_91087_().f_91062_;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)centerX - (float)font.m_92852_((FormattedText)s) / 2.0f + 0.5f, (float)centerY - 3.5f, 0.0f);
                graphics.m_280614_(font, (Component)s, 0, 0, color, false);
                graphics.m_280168_().m_85849_();
            }

            @Override
            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                return Tooltip.create(context.getPoint(), new Component[]{Component.m_237110_((String)"text.rei.gamemode_button.tooltip.entry", (Object[])new Object[]{type.m_151499_().getString()})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(this.getClass(), false, type);
            }
        };
    }

    @Override
    public boolean doAction(int button) {
        if (button == 0) {
            GameType mode = this.gameMode;
            if (mode == null) {
                mode = GameType.m_46393_((int)(Minecraft.m_91087_().f_91072_.m_105295_().m_46392_() + 1));
            }
            Minecraft.m_91087_().f_91074_.f_108617_.m_246623_(StringUtils.removeStart((String)ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", mode.name().toLowerCase(Locale.ROOT)), (String)"/"));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.gameMode == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.filterAndMap(Arrays.asList(GameType.values()), type -> type.m_46392_() >= 0, GameModeMenuEntry::new);
    }

    @Override
    public long hashIgnoreAmount() {
        return this.gameMode == null ? 31290831290L : (long)this.gameMode.ordinal();
    }

    @Override
    public FavoriteEntry copy() {
        return this;
    }

    @Override
    public ResourceLocation getType() {
        return ID;
    }

    @Override
    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof GameModeFavoriteEntry)) {
            return false;
        }
        GameModeFavoriteEntry that = (GameModeFavoriteEntry)other;
        return Objects.equals(this.gameMode, that.gameMode);
    }

    public static class GameModeMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final GameType gameMode;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public GameModeMenuEntry(GameType gameMode) {
            this.text = gameMode.m_151499_().getString();
            this.gameMode = gameMode;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.m_92895_(this.text));
            }
            return this.textWidth;
        }

        @Override
        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        @Override
        public int getEntryHeight() {
            return 12;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            boolean disabled;
            boolean bl = disabled = this.minecraft.f_91072_.m_105295_() == this.gameMode;
            if (this.selected && !disabled) {
                graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + 12, -12237499);
            }
            if (!disabled && this.selected && this.containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create(new Component[]{Component.m_237110_((String)"text.rei.gamemode_button.tooltip.entry", (Object[])new Object[]{this.text})}));
            }
            Object s = this.text;
            if (disabled) {
                s = ChatFormatting.STRIKETHROUGH + (String)s;
            }
            graphics.m_280056_(this.font, (String)s, this.x + 2, this.y + 2, this.selected && !disabled ? 0xFFFFFF : 0x888888, false);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            boolean disabled;
            boolean bl = disabled = this.minecraft.f_91072_.m_105295_() == this.gameMode;
            if (!disabled && this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12)) {
                Minecraft.m_91087_().f_91074_.f_108617_.m_246623_(StringUtils.removeStart((String)ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", this.gameMode.name().toLowerCase(Locale.ROOT)), (String)"/"));
                this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.closeMenu();
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    public static enum Type implements FavoriteEntryType<GameModeFavoriteEntry>
    {
        INSTANCE;


        @Override
        public DataResult<GameModeFavoriteEntry> read(CompoundTag object) {
            String stringValue = object.m_128461_(GameModeFavoriteEntry.KEY);
            GameType type = stringValue.equals("NOT_SET") ? null : GameType.valueOf((String)stringValue);
            return DataResult.success((Object)new GameModeFavoriteEntry(type), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<GameModeFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create GameModeFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof GameType)) {
                return DataResult.error(() -> "Creation of GameModeFavoriteEntry from args expected GameType as the first argument!");
            }
            GameType type = (GameType)object;
            return DataResult.success((Object)new GameModeFavoriteEntry(type), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public CompoundTag save(GameModeFavoriteEntry entry, CompoundTag tag) {
            tag.m_128359_(GameModeFavoriteEntry.KEY, entry.gameMode == null ? "NOT_SET" : entry.gameMode.name());
            return tag;
        }
    }
}

