/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.hooks.item.ItemStackHooks;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ItemEntryDefinition
implements EntryDefinition<ItemStack>,
EntrySerializer<ItemStack> {
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<ItemStack> renderer;
    private static final ReferenceSet<Item> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public ItemEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    @Override
    public Class<ItemStack> getValueType() {
        return ItemStack.class;
    }

    @Override
    public EntryType<ItemStack> getType() {
        return VanillaEntryTypes.ITEM;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<ItemStack> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<ItemStack> entry, ItemStack value) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)value.m_41720_());
    }

    @Override
    public boolean isEmpty(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_41619_();
    }

    @Override
    public ItemStack copy(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_41777_();
    }

    @Override
    public ItemStack normalize(EntryStack<ItemStack> entry, ItemStack value) {
        ItemStack copy = value.m_41777_();
        copy.m_41764_(1);
        return copy;
    }

    @Override
    public ItemStack wildcard(EntryStack<ItemStack> entry, ItemStack value) {
        return new ItemStack((ItemLike)value.m_41720_(), 1);
    }

    @Override
    @Nullable
    public ItemStack cheatsAs(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_41777_();
    }

    @Override
    @Nullable
    public ItemStack add(ItemStack o1, ItemStack o2) {
        return ItemStackHooks.copyWithCount((ItemStack)o1, (int)(o1.m_41613_() + o2.m_41613_()));
    }

    @Override
    public long hash(EntryStack<ItemStack> entry, ItemStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + System.identityHashCode(value.m_41720_());
        code = 31 * code + Long.hashCode(ItemComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(ItemStack o1, ItemStack o2, ComparisonContext context) {
        if (o1.m_41720_() != o2.m_41720_()) {
            return false;
        }
        return ItemComparatorRegistry.getInstance().hashOf(context, o1) == ItemComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<ItemStack> getSerializer() {
        return this;
    }

    @Override
    public boolean supportSaving() {
        return true;
    }

    @Override
    public boolean supportReading() {
        return true;
    }

    @Override
    public boolean acceptsNull() {
        return false;
    }

    @Override
    public CompoundTag save(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_41739_(new CompoundTag());
    }

    @Override
    public ItemStack read(CompoundTag tag) {
        return ItemStack.m_41712_((CompoundTag)tag);
    }

    @Override
    public Component asFormattedText(EntryStack<ItemStack> entry, ItemStack value) {
        return this.asFormattedText(entry, value, TooltipContext.of());
    }

    @Override
    public Component asFormattedText(EntryStack<ItemStack> entry, ItemStack value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.m_41720_())) {
            try {
                return value.m_41786_();
            }
            catch (Throwable e) {
                if (context != null && context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.m_41720_());
            }
        }
        try {
            return Component.m_237113_((String)I18n.m_118938_((String)("item." + BuiltInRegistries.f_257033_.m_7981_((Object)value.m_41720_()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Component.m_237113_((String)"ERROR");
        }
    }

    @Override
    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<ItemStack> entry, ItemStack value) {
        Stream tags = value.m_204131_();
        Item item = value.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            tags = Stream.concat(tags, blockItem.m_40614_().m_204297_().m_203616_());
        }
        return tags;
    }

    @OnlyIn(value=Dist.CLIENT)
    private List<Component> tryGetItemStackToolTip(EntryStack<ItemStack> entry, ItemStack value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.m_41720_())) {
            try {
                return value.m_41651_((Player)Minecraft.m_91087_().f_91074_, context.getFlag());
            }
            catch (Throwable e) {
                if (context.isSearch()) {
                    throw e;
                }
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.m_41720_());
            }
        }
        return Lists.newArrayList((Object[])new Component[]{this.asFormattedText(entry, value, context)});
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<ItemStack> entry) {
        EntryDefinition.super.fillCrashReport(report, category, entry);
        ItemStack stack = entry.getValue();
        category.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
        category.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
        category.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
        category.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(ItemEntryDefinition definition) {
            definition.renderer = definition.new ItemEntryRenderer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ItemEntryRenderer
    implements BatchedEntryRenderer<ItemStack, BakedModel> {
        private static final float SCALE = 20.0f;
        public static final int ITEM_LIGHT = 0xF000F0;

        @Override
        public BakedModel getExtraData(EntryStack<ItemStack> entry) {
            Minecraft minecraft = Minecraft.m_91087_();
            return minecraft.m_91291_().m_174264_(entry.getValue(), (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        }

        @Override
        public void render(EntryStack<ItemStack> entry, GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
            BakedModel model = this.getExtraData(entry);
            this.setupGL(entry, model);
            if (!entry.isEmpty()) {
                ItemStack value = entry.getValue();
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)bounds.getCenterX(), (float)bounds.getCenterY(), 0.0f);
                graphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                graphics.m_280168_().m_85841_((float)bounds.getWidth(), (float)bounds.getHeight(), (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f);
                MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
                Minecraft.m_91087_().m_91291_().m_115143_(value, ItemDisplayContext.GUI, false, graphics.m_280168_(), (MultiBufferSource)immediate, 0xF000F0, OverlayTexture.f_118083_, model);
                immediate.m_109911_();
                graphics.m_280168_().m_85849_();
            }
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.m_85836_();
            modelViewStack.m_252931_(graphics.m_280168_().m_85850_().m_252922_());
            modelViewStack.m_252880_((float)bounds.x, (float)bounds.y, 0.0f);
            modelViewStack.m_85841_((float)bounds.width / 16.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 16.0f, 1.0f);
            RenderSystem.applyModelViewMatrix();
            this.renderOverlay(new GuiGraphics(Minecraft.m_91087_(), graphics.m_280091_()), entry, bounds);
            modelViewStack.m_85849_();
            this.endGL(entry, model);
            RenderSystem.applyModelViewMatrix();
        }

        @Override
        public int getBatchIdentifier(EntryStack<ItemStack> entry, Rectangle bounds, BakedModel model) {
            return 1738923 + (model.m_7547_() ? 1 : 0);
        }

        @Override
        public void startBatch(EntryStack<ItemStack> entry, BakedModel model, GuiGraphics graphics, float delta) {
            this.setupGL(entry, model);
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.m_85836_();
            modelViewStack.m_85841_(20.0f, -20.0f, 1.0f);
            RenderSystem.applyModelViewMatrix();
        }

        public void setupGL(EntryStack<ItemStack> entry, BakedModel model) {
            Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean sideLit = model.m_7547_();
            if (!sideLit) {
                Lighting.m_84930_();
            }
        }

        @Override
        public void renderBase(EntryStack<ItemStack> entry, BakedModel model, GuiGraphics graphics, MultiBufferSource.BufferSource immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                ItemStack value = entry.getValue();
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)bounds.getCenterX() / 20.0f, (float)bounds.getCenterY() / -20.0f, 0.0f);
                graphics.m_280168_().m_85841_((float)bounds.getWidth() / 20.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 20.0f, 1.0f);
                Minecraft.m_91087_().m_91291_().m_115143_(value, ItemDisplayContext.GUI, false, graphics.m_280168_(), (MultiBufferSource)immediate, 0xF000F0, OverlayTexture.f_118083_, model);
                graphics.m_280168_().m_85849_();
            }
        }

        @Override
        public void afterBase(EntryStack<ItemStack> entry, BakedModel model, GuiGraphics graphics, float delta) {
            this.endGL(entry, model);
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
        }

        @Override
        public void renderOverlay(EntryStack<ItemStack> entry, BakedModel model, GuiGraphics graphics, MultiBufferSource.BufferSource immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.m_85836_();
            modelViewStack.m_252931_(graphics.m_280168_().m_85850_().m_252922_());
            modelViewStack.m_252880_((float)bounds.x, (float)bounds.y, 0.0f);
            modelViewStack.m_85841_((float)bounds.width / 16.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 16.0f, 1.0f);
            RenderSystem.applyModelViewMatrix();
            this.renderOverlay(new GuiGraphics(Minecraft.m_91087_(), graphics.m_280091_()), entry, bounds);
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }

        public void renderOverlay(GuiGraphics graphics, EntryStack<ItemStack> entry, Rectangle bounds) {
            if (!entry.isEmpty()) {
                graphics.m_280302_(Minecraft.m_91087_().f_91062_, entry.getValue(), 0, 0, null);
            }
        }

        @Override
        public void endBatch(EntryStack<ItemStack> entry, BakedModel model, GuiGraphics graphics, float delta) {
        }

        public void endGL(EntryStack<ItemStack> entry, BakedModel model) {
            RenderSystem.enableDepthTest();
            boolean sideLit = model.m_7547_();
            if (!sideLit) {
                Lighting.m_84931_();
            }
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<ItemStack> entry, TooltipContext context) {
            if (entry.isEmpty()) {
                return null;
            }
            Tooltip tooltip = Tooltip.create(new Component[0]);
            Optional component = entry.getValue().m_150921_();
            List<Component> components = ItemEntryDefinition.this.tryGetItemStackToolTip(entry, entry.getValue(), context);
            if (!components.isEmpty()) {
                tooltip.add(components.get(0));
            }
            component.ifPresent(tooltip::add);
            for (int i = 1; i < components.size(); ++i) {
                tooltip.add(components.get(i));
            }
            return tooltip;
        }
    }
}

