/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.impl.common.transfer.InputSlotCrafter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class LegacyInputSlotCrafter<T extends AbstractContainerMenu, C extends Container, D extends Display>
extends InputSlotCrafter<T, C>
implements MenuInfoContext<T, ServerPlayer, D> {
    protected CategoryIdentifier<D> category;
    protected MenuInfo<T, D> menuInfo;

    protected LegacyInputSlotCrafter(CategoryIdentifier<D> category, T container) {
        super(container);
        this.category = category;
    }

    public void setMenuInfo(MenuInfo<T, D> menuInfo) {
        this.menuInfo = menuInfo;
    }

    public static <T extends AbstractContainerMenu, C extends Container, D extends Display> LegacyInputSlotCrafter<T, C, D> start(CategoryIdentifier<D> category, T menu, ServerPlayer player, CompoundTag display, boolean hasShift) {
        LegacyInputSlotCrafter<T, C, D> crafter = new LegacyInputSlotCrafter<T, C, D>(category, menu);
        MenuInfo<T, D> menuInfo = Objects.requireNonNull(MenuInfoRegistry.getInstance().get(category, menu, crafter, display), "Container Info does not exist on the server!");
        crafter.setMenuInfo(menuInfo);
        crafter.fillInputSlots(player, hasShift);
        return crafter;
    }

    @Override
    protected Iterable<SlotAccessor> getInputSlots() {
        return this.menuInfo.getInputSlots(this);
    }

    @Override
    protected Iterable<SlotAccessor> getInventorySlots() {
        return this.menuInfo.getInventorySlots(this);
    }

    @Override
    protected List<InputIngredient<ItemStack>> getInputs() {
        return this.menuInfo.getInputsIndexed(this, true);
    }

    @Override
    protected void populateRecipeFinder(RecipeFinder recipeFinder) {
        this.menuInfo.getRecipeFinderPopulator().populate(this, recipeFinder);
    }

    @Override
    protected void markDirty() {
        this.menuInfo.markDirty(this);
    }

    @Override
    protected void cleanInputs() {
        this.menuInfo.getInputCleanHandler().clean(this);
    }

    @Override
    public T getMenu() {
        return (T)this.container;
    }

    @Override
    public ServerPlayer getPlayerEntity() {
        return this.player;
    }

    @Override
    public D getDisplay() {
        return this.menuInfo.getDisplay();
    }

    @Override
    public CategoryIdentifier<D> getCategoryIdentifier() {
        return this.category;
    }
}

