/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.config.REIConfigScreen;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.config.options.OptionCategory;
import me.shedaniel.rei.impl.client.gui.config.options.OptionGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ConfigSearchWidget {
    public static WidgetWithBounds create(final IntSupplier width) {
        final Label label = Widgets.createLabel(new Point(21, 6), (Component)ConfigUtils.translatable("config.rei.texts.search_options")).leftAligned();
        Font font = Minecraft.m_91087_().f_91062_;
        Rectangle bounds = new Rectangle(0, 0, label.getBounds().getMaxX(), 21);
        return Widgets.concatWithBounds(bounds, new Widget(){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hovering = new Rectangle(-1, -1, width.getAsInt() + 2, 21).contains(mouseX, mouseY);
                for (Widget widget : List.of(Widgets.createFilledRectangle(new Rectangle(1, 1, width.getAsInt() - 2, 18), hovering ? 0x50FFFFFF : 0x25FFFFFF), Widgets.createFilledRectangle(new Rectangle(-1, -1, width.getAsInt() + 2, 1), hovering ? -1862270977 : 0x45FFFFFF), Widgets.createFilledRectangle(new Rectangle(-1, 20, width.getAsInt() + 2, 1), hovering ? -1862270977 : 0x45FFFFFF), Widgets.createFilledRectangle(new Rectangle(-1, 0, 1, 20), hovering ? -1862270977 : 0x45FFFFFF), Widgets.createFilledRectangle(new Rectangle(width.getAsInt(), 0, 1, 20), hovering ? -1862270977 : 0x45FFFFFF))) {
                    widget.m_88315_(graphics, mouseX, mouseY, delta);
                }
                label.setColor(hovering ? -1973791 : -4144960);
            }

            public List<? extends GuiEventListener> m_6702_() {
                return List.of();
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (new Rectangle(-1, -1, width.getAsInt() + 2, 21).contains(mouseX, mouseY)) {
                    Widgets.produceClickSound();
                    ((REIConfigScreen)Minecraft.m_91087_().f_91080_).setSearching(true);
                    return true;
                }
                return false;
            }
        }, Widgets.withTranslate(label, 0.0, 0.5, 0.0), Widgets.createTexturedWidget(new ResourceLocation("roughlyenoughitems:textures/gui/config/search_options.png"), new Rectangle(3, 3, 16, 16), 0.0f, 0.0f, 1, 1, 1, 1));
    }

    public static WidgetWithBounds createTiny() {
        Rectangle bounds = new Rectangle(0, 0, 16, 16);
        return Widgets.withTooltip(Widgets.concatWithBounds(bounds, new Widget(){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                boolean hovering = new Rectangle(-1, -1, 18, 18).contains(mouseX, mouseY);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85837_(-0.5, -0.5, 0.0);
                for (Widget widget : List.of(Widgets.createFilledRectangle(new Rectangle(-1, -1, 18, 18), hovering ? 0x50FFFFFF : 0x25FFFFFF), Widgets.createFilledRectangle(new Rectangle(-3, -3, 22, 1), hovering ? -1862270977 : 0x45FFFFFF), Widgets.createFilledRectangle(new Rectangle(-3, 18, 22, 1), hovering ? -1862270977 : 0x45FFFFFF), Widgets.createFilledRectangle(new Rectangle(-3, -2, 1, 20), hovering ? -1862270977 : 0x45FFFFFF), Widgets.createFilledRectangle(new Rectangle(18, -2, 1, 20), hovering ? -1862270977 : 0x45FFFFFF))) {
                    widget.m_88315_(graphics, mouseX, mouseY, delta);
                }
                graphics.m_280168_().m_85849_();
            }

            public List<? extends GuiEventListener> m_6702_() {
                return List.of();
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (new Rectangle(-1, -1, 18, 18).contains(mouseX, mouseY)) {
                    Widgets.produceClickSound();
                    ((REIConfigScreen)Minecraft.m_91087_().f_91080_).setSearching(true);
                    return true;
                }
                return false;
            }
        }, Widgets.createTexturedWidget(new ResourceLocation("roughlyenoughitems:textures/gui/config/search_options.png"), bounds, 0.0f, 0.0f, 1, 1, 1, 1)), new Component[]{ConfigUtils.translatable("config.rei.texts.search_options")});
    }

    public static Collection<SearchResult> matchResult(List<OptionCategory> categories, String searchTerm) {
        if (searchTerm.isBlank()) {
            return Collections.emptyList();
        }
        List<ScoredResult> scoredResults = ConfigSearchWidget.collectSearchResults(categories, searchTerm);
        scoredResults.removeIf(result -> result.result() instanceof CategoryResult);
        LinkedHashSet<SearchResult> distinctResults = new LinkedHashSet<SearchResult>();
        for (ScoredResult result2 : scoredResults) {
            if (!(result2.score() >= 0.001f)) continue;
            distinctResults.add(result2.result());
        }
        HashSet<OptionCategory> visitedCategories = new HashSet<OptionCategory>();
        HashSet<OptionGroup> visitedGroups = new HashSet<OptionGroup>();
        Iterator iterator = distinctResults.iterator();
        while (iterator.hasNext()) {
            IndividualResult individualResult;
            SearchResult result3 = (SearchResult)iterator.next();
            if (result3 instanceof CategoryResult) {
                CategoryResult categoryResult = (CategoryResult)result3;
                visitedCategories.add(categoryResult.category());
                continue;
            }
            if (result3 instanceof GroupResult) {
                GroupResult groupResult = (GroupResult)result3;
                if (visitedCategories.contains(((GroupResult)result3).category)) {
                    iterator.remove();
                    continue;
                }
                visitedGroups.add(groupResult.group());
                continue;
            }
            if (!(result3 instanceof IndividualResult) || !visitedCategories.contains((individualResult = (IndividualResult)result3).category()) && !visitedGroups.contains(individualResult.group())) continue;
            iterator.remove();
        }
        return distinctResults;
    }

    private static List<ScoredResult> collectSearchResults(List<OptionCategory> categories, String searchTerm) {
        String lcSearchTerm = searchTerm.toLowerCase(Locale.ROOT);
        ArrayList<Record> results = new ArrayList<Record>();
        ArrayList<Record> fuzzyResults = new ArrayList<Record>();
        for (OptionCategory category : categories) {
            if (category.getKey().toLowerCase(Locale.ROOT).contains(lcSearchTerm)) {
                results.add(new CategoryResult(category, new MatchComposite(category.getKey(), MatchType.KEY)));
            } else {
                fuzzyResults.add(new CategoryResult(category, new MatchComposite(category.getKey(), MatchType.KEY)));
            }
            if (category.getName().getString().toLowerCase(Locale.ROOT).contains(lcSearchTerm)) {
                results.add(new CategoryResult(category, new MatchComposite(category.getName().getString(), MatchType.NAME)));
            } else {
                fuzzyResults.add(new CategoryResult(category, new MatchComposite(category.getName().getString(), MatchType.NAME)));
            }
            if (!category.getDescription().getString().endsWith(".desc") && category.getDescription().getString().toLowerCase(Locale.ROOT).contains(lcSearchTerm)) {
                results.add(new CategoryResult(category, new MatchComposite(category.getDescription().getString(), MatchType.DESCRIPTION)));
            } else {
                fuzzyResults.add(new CategoryResult(category, new MatchComposite(category.getDescription().getString(), MatchType.DESCRIPTION)));
            }
            for (OptionGroup group : category.getGroups()) {
                if (group.getId().toLowerCase(Locale.ROOT).contains(lcSearchTerm)) {
                    results.add(new GroupResult(category, group, new MatchComposite(group.getId(), MatchType.KEY)));
                } else {
                    fuzzyResults.add(new GroupResult(category, group, new MatchComposite(group.getId(), MatchType.KEY)));
                }
                if (group.getGroupName().getString().toLowerCase(Locale.ROOT).contains(lcSearchTerm)) {
                    results.add(new GroupResult(category, group, new MatchComposite(group.getGroupName().getString(), MatchType.NAME)));
                } else {
                    fuzzyResults.add(new GroupResult(category, group, new MatchComposite(group.getGroupName().getString(), MatchType.NAME)));
                }
                for (CompositeOption<?> option : group.getOptions()) {
                    if (option.getId().toLowerCase(Locale.ROOT).contains(lcSearchTerm)) {
                        results.add(new IndividualResult(category, group, option, new MatchComposite(option.getId(), MatchType.KEY)));
                    } else {
                        fuzzyResults.add(new IndividualResult(category, group, option, new MatchComposite(option.getId(), MatchType.KEY)));
                    }
                    if (option.getName().getString().toLowerCase(Locale.ROOT).contains(lcSearchTerm)) {
                        results.add(new IndividualResult(category, group, option, new MatchComposite(option.getName().getString(), MatchType.NAME)));
                    } else {
                        fuzzyResults.add(new IndividualResult(category, group, option, new MatchComposite(option.getName().getString(), MatchType.NAME)));
                    }
                    if (!option.getDescription().getString().endsWith(".desc") && option.getDescription().getString().toLowerCase(Locale.ROOT).contains(lcSearchTerm)) {
                        results.add(new IndividualResult(category, group, option, new MatchComposite(option.getDescription().getString(), MatchType.DESCRIPTION)));
                        continue;
                    }
                    fuzzyResults.add(new IndividualResult(category, group, option, new MatchComposite(option.getDescription().getString(), MatchType.DESCRIPTION)));
                }
            }
        }
        return Stream.concat(results.stream().map(result -> new ScoredResult((SearchResult)result, ConfigSearchWidget.similarity(result.matched().matched(), searchTerm) * result.matched().type().multiplier())), fuzzyResults.stream().map(result -> new ScoredResult((SearchResult)result, (float)Math.pow(ConfigSearchWidget.similarity(result.matched().matched(), searchTerm), 1.5) * result.matched().type().multiplier() * 0.9f)).filter(result -> result.score() > 0.5f)).sorted(Comparator.comparingDouble(ScoredResult::score).reversed()).collect(Collectors.toList());
    }

    private static float similarity(String first, String second) {
        String firstLowerCase = first.toLowerCase(Locale.ROOT);
        String secondLowerCase = second.toLowerCase(Locale.ROOT);
        if (!Objects.equals(first, firstLowerCase) || !Objects.equals(second, secondLowerCase)) {
            return (ConfigSearchWidget.innerSimilarity(first, second) + ConfigSearchWidget.innerSimilarity(firstLowerCase, secondLowerCase)) / 2.0f;
        }
        return ConfigSearchWidget.innerSimilarity(first, second);
    }

    private static float innerSimilarity(String first, String second) {
        int longerLength;
        String longer = first;
        String shorter = second;
        if (first.length() < second.length()) {
            longer = second;
            shorter = first;
        }
        if ((longerLength = longer.length()) == 0) {
            return 1.0f;
        }
        return (float)(longerLength - ConfigSearchWidget.editDistance(longer, shorter)) / (float)longerLength;
    }

    private static int editDistance(String s11, String s22) {
        int[] costs = new int[s22.length() + 1];
        for (int i = 0; i <= s11.length(); ++i) {
            int lastValue = i;
            for (int j = 0; j <= s22.length(); ++j) {
                if (i == 0) {
                    costs[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int newValue = costs[j - 1];
                if (s11.charAt(i - 1) != s22.charAt(j - 1)) {
                    newValue = Math.min(Math.min(newValue, lastValue), costs[j]) + 1;
                }
                costs[j - 1] = lastValue;
                lastValue = newValue;
            }
            if (i <= 0) continue;
            costs[s22.length()] = lastValue;
        }
        return costs[s22.length()];
    }

    public record ScoredResult(SearchResult result, float score) {
    }

    public static interface SearchResult {
        public MatchComposite matched();

        public Object decompose(String var1);
    }

    public record CategoryResult(OptionCategory category, MatchComposite matched) implements SearchResult
    {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CategoryResult that = (CategoryResult)o;
            return Objects.equals(this.category, that.category);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.category);
        }

        @Override
        public Object decompose(String searchTerm) {
            return this.category();
        }
    }

    public record GroupResult(OptionCategory category, OptionGroup group, MatchComposite matched) implements SearchResult
    {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupResult that = (GroupResult)o;
            return Objects.equals(this.group, that.group);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.group);
        }

        @Override
        public Object decompose(String searchTerm) {
            OptionGroup copied = this.group().copy();
            copied.setGroupNameHighlight(searchTerm);
            return copied;
        }
    }

    public record IndividualResult(OptionCategory category, OptionGroup group, CompositeOption<?> option, MatchComposite matched) implements SearchResult
    {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndividualResult that = (IndividualResult)o;
            return Objects.equals(this.option, that.option);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.option);
        }

        @Override
        public Object decompose(String searchTerm) {
            CompositeOption<?> copied = this.option().copy();
            if (this.matched().type() == MatchType.NAME) {
                copied.setOptionNameHighlight(searchTerm);
            } else if (this.matched().type() == MatchType.DESCRIPTION) {
                copied.setOptionDescriptionHighlight(searchTerm);
            }
            return new IndividualResult(this.category(), this.group(), copied, this.matched());
        }
    }

    public record MatchComposite(String matched, MatchType type) {
    }

    public static enum MatchType {
        KEY(5.0E-4f),
        NAME(0.98f),
        DESCRIPTION(0.8f);

        private final float multiplier;

        private MatchType(float multiplier) {
            this.multiplier = multiplier;
        }

        public float multiplier() {
            return this.multiplier;
        }
    }
}

