/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.renderer;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRendererProvider;
import me.shedaniel.rei.api.client.entry.renderer.EntryRendererRegistry;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;

public class EntryRendererRegistryImpl
implements EntryRendererRegistry {
    private final Multimap<EntryType<?>, EntryRendererProvider<?>> providers = Multimaps.newListMultimap((Map)new Reference2ObjectOpenHashMap(), ArrayList::new);

    @Override
    public <T> void register(EntryType<T> type, EntryRendererProvider<T> provider) {
        this.providers.put(type, provider);
    }

    @Override
    public <T> EntryRenderer<T> get(EntryStack<T> stack) {
        EntryRenderer<T> renderer = stack.getDefinition().getRenderer();
        for (EntryRendererProvider provider : this.providers.get(stack.getType())) {
            renderer = Objects.requireNonNull(provider.provide(stack, renderer));
        }
        return renderer;
    }

    @Override
    public void startReload() {
        this.providers.clear();
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerEntryRenderers(this);
    }
}

