/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.util.Size2i;

public final class MathUtil {
    private static final List<Rectangle2dCropper> rectangle2dCroppers = Arrays.asList(MathUtil::cropTop, MathUtil::cropBottom, MathUtil::cropLeft, MathUtil::cropRight);
    private static final Rect2i emptyRect = new Rect2i(0, 0, 0, 0);

    private MathUtil() {
    }

    public static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    public static boolean intersects(Collection<Rect2i> areas, Rect2i comparisonArea) {
        for (Rect2i area : areas) {
            if (!MathUtil.intersects(area, comparisonArea)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(Rect2i rect1, Rect2i rect2) {
        if (rect1.m_110090_() <= 0 || rect1.m_110091_() <= 0) {
            return false;
        }
        return rect2.m_110085_() + rect2.m_110090_() > rect1.m_110085_() && rect2.m_110086_() + rect2.m_110091_() > rect1.m_110086_() && rect2.m_110085_() < rect1.m_110085_() + rect1.m_110090_() && rect2.m_110086_() < rect1.m_110086_() + rect1.m_110091_();
    }

    public static Rect2i cropToAvoidIntersection(Collection<Rect2i> areas, Rect2i comparisonArea, Size2i maxContentSize) {
        return areas.stream().filter(rectangle2d -> MathUtil.intersects(rectangle2d, comparisonArea)).sorted(Comparator.comparingInt(r -> MathUtil.contentArea(r, maxContentSize))).reduce(comparisonArea, (r1, r2) -> MathUtil.bestCrop(r1, r2, maxContentSize));
    }

    private static Rect2i bestCrop(Rect2i rect, Rect2i intersecting, Size2i maxContentSize) {
        if (MathUtil.contentArea(rect, maxContentSize) == 0) {
            return rect;
        }
        return rectangle2dCroppers.stream().map(cropper -> cropper.crop(rect, intersecting)).max(Comparator.comparingInt(r -> MathUtil.contentArea(r, maxContentSize))).orElse(emptyRect);
    }

    public static int contentArea(Rect2i rect, Size2i maxContentSize) {
        if (rect.m_110090_() <= 0 || rect.m_110091_() <= 0) {
            return 0;
        }
        return Math.min(rect.m_110090_(), maxContentSize.width) * Math.min(rect.m_110091_(), maxContentSize.height);
    }

    private static Rect2i cropTop(Rect2i original, Rect2i intersecting) {
        int newY;
        int maxY = original.m_110086_() + original.m_110091_();
        if (maxY < (newY = intersecting.m_110086_() + intersecting.m_110091_())) {
            return emptyRect;
        }
        return new Rect2i(original.m_110085_(), newY, original.m_110090_(), maxY - newY);
    }

    private static Rect2i cropBottom(Rect2i original, Rect2i intersecting) {
        int newHeight = intersecting.m_110086_() - original.m_110086_();
        if (newHeight < 0) {
            return emptyRect;
        }
        return new Rect2i(original.m_110085_(), original.m_110086_(), original.m_110090_(), newHeight);
    }

    private static Rect2i cropRight(Rect2i original, Rect2i intersecting) {
        int newWidth = intersecting.m_110085_() - original.m_110085_();
        if (newWidth < 0) {
            return emptyRect;
        }
        return new Rect2i(original.m_110085_(), original.m_110086_(), newWidth, original.m_110091_());
    }

    private static Rect2i cropLeft(Rect2i original, Rect2i intersecting) {
        int newX;
        int maxX = original.m_110085_() + original.m_110090_();
        if (maxX < (newX = intersecting.m_110085_() + intersecting.m_110090_())) {
            return emptyRect;
        }
        return new Rect2i(newX, original.m_110086_(), maxX - newX, original.m_110091_());
    }

    public static boolean contains(Collection<Rect2i> areas, double x, double y) {
        for (Rect2i guiArea : areas) {
            if (!MathUtil.contains(guiArea, x, y)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Rect2i rect, double x, double y) {
        return x >= (double)rect.m_110085_() && y >= (double)rect.m_110086_() && x < (double)(rect.m_110085_() + rect.m_110090_()) && y < (double)(rect.m_110086_() + rect.m_110091_());
    }

    public static Rect2i union(Rect2i rect1, Rect2i rect2) {
        long tx2 = rect1.m_110090_();
        long ty2 = rect1.m_110091_();
        long rx2 = rect2.m_110090_();
        long ry2 = rect2.m_110091_();
        int tx1 = rect1.m_110085_();
        int ty1 = rect1.m_110086_();
        tx2 += (long)tx1;
        ty2 += (long)ty1;
        int rx1 = rect2.m_110085_();
        int ry1 = rect2.m_110086_();
        rx2 += (long)rx1;
        ry2 += (long)ry1;
        if (tx1 > rx1) {
            tx1 = rx1;
        }
        if (ty1 > ry1) {
            ty1 = ry1;
        }
        if (tx2 < rx2) {
            tx2 = rx2;
        }
        if (ty2 < ry2) {
            ty2 = ry2;
        }
        tx2 -= (long)tx1;
        ty2 -= (long)ty1;
        tx2 = Math.min(tx2, Integer.MAX_VALUE);
        ty2 = Math.min(ty2, Integer.MAX_VALUE);
        return new Rect2i(tx1, ty1, (int)tx2, (int)ty2);
    }

    public static Rect2i centerTextArea(Rect2i outer, Font fontRenderer, String text) {
        int width = fontRenderer.m_92895_(text);
        Objects.requireNonNull(fontRenderer);
        int height = 9;
        return MathUtil.centerArea(outer, width, height);
    }

    public static Rect2i centerTextArea(Rect2i outer, Font fontRenderer, FormattedText text) {
        int width = fontRenderer.m_92852_(text);
        Objects.requireNonNull(fontRenderer);
        int height = 9;
        return MathUtil.centerArea(outer, width, height);
    }

    public static Rect2i centerArea(Rect2i outer, int width, int height) {
        return new Rect2i(outer.m_110085_() + Math.round((float)(outer.m_110090_() - width) / 2.0f), outer.m_110086_() + Math.round((float)(outer.m_110091_() - height) / 2.0f), width, height);
    }

    public static double distance(Vec2 start, Vec2 end) {
        double a = start.f_82470_ - end.f_82470_;
        double b = start.f_82471_ - end.f_82471_;
        return Math.sqrt(a * a + b * b);
    }

    public static Tuple<Rect2i, Rect2i> splitY(Rect2i rectangle, int y) {
        Rect2i rectTop = new Rect2i(rectangle.m_110085_(), rectangle.m_110086_(), rectangle.m_110090_(), y);
        Rect2i rectBottom = new Rect2i(rectangle.m_110085_(), rectangle.m_110086_() + y, rectangle.m_110090_(), rectangle.m_110091_() - y);
        return new Tuple((Object)rectTop, (Object)rectBottom);
    }

    public static Tuple<Rect2i, Rect2i> splitYBottom(Rect2i rectangle, int y) {
        return MathUtil.splitY(rectangle, rectangle.m_110091_() - y);
    }

    public static Tuple<Rect2i, Rect2i> splitX(Rect2i rectangle, int x) {
        Rect2i rectLeft = new Rect2i(rectangle.m_110085_(), rectangle.m_110086_(), x, rectangle.m_110091_());
        Rect2i rectRight = new Rect2i(rectangle.m_110085_() + x, rectangle.m_110086_(), rectangle.m_110090_() - x, rectangle.m_110091_());
        return new Tuple((Object)rectLeft, (Object)rectRight);
    }

    public static Tuple<Rect2i, Rect2i> splitXRight(Rect2i rectangle, int x) {
        return MathUtil.splitX(rectangle, rectangle.m_110090_() - x);
    }

    public static boolean equalRects(Collection<Rect2i> a, Collection<Rect2i> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Rect2i aRect : a) {
            if (MathUtil.containsRect(b, aRect)) continue;
            return false;
        }
        return true;
    }

    public static Rect2i copyRect(Rect2i rect) {
        return new Rect2i(rect.m_110085_(), rect.m_110086_(), rect.m_110090_(), rect.m_110091_());
    }

    private static boolean containsRect(Collection<Rect2i> rects, Rect2i aRect) {
        for (Rect2i bRect : rects) {
            if (aRect.m_110085_() != bRect.m_110085_() || aRect.m_110086_() != bRect.m_110086_() || aRect.m_110090_() != bRect.m_110090_() || aRect.m_110091_() != bRect.m_110091_()) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    private static interface Rectangle2dCropper {
        public Rect2i crop(Rect2i var1, Rect2i var2);
    }
}

