/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.jeicompat.CompatPlatform;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public enum JEISubtypeRegistration implements ISubtypeRegistration
{
    INSTANCE;


    @Override
    public <B, I> void registerSubtypeInterpreter(IIngredientTypeWithSubtypes<B, I> type, B base, IIngredientSubtypeInterpreter<I> interpreter) {
        EntryType reiType = JEIPluginDetector.unwrapType(type);
        if (reiType == VanillaEntryTypes.ITEM) {
            this.registerSubtypeInterpreter((Item)base, interpreter);
        } else if (reiType == VanillaEntryTypes.FLUID) {
            this.registerSubtypeInterpreter((Fluid)base, interpreter);
        }
    }

    @Override
    public void registerSubtypeInterpreter(@NotNull Item item, @NotNull IIngredientSubtypeInterpreter<ItemStack> interpreter) {
        if (interpreter == null) {
            return;
        }
        ItemComparatorRegistry.getInstance().register(JEISubtypeRegistration.wrapItemComparator(interpreter), (Object)item);
    }

    public void registerSubtypeInterpreter(@NotNull Fluid fluid, @NotNull IIngredientSubtypeInterpreter<Object> interpreter) {
        if (interpreter == null) {
            return;
        }
        FluidComparatorRegistry.getInstance().register(JEISubtypeRegistration.wrapFluidComparator(interpreter), (Object)fluid);
    }

    @Override
    public void useNbtForSubtypes(Item ... items) {
        ItemComparatorRegistry.getInstance().registerNbt(items);
    }

    @Override
    public void useNbtForSubtypes(Fluid ... fluids) {
        FluidComparatorRegistry.getInstance().registerNbt(fluids);
    }

    public boolean hasSubtypeInterpreter(@NotNull ItemStack itemStack) {
        return ItemComparatorRegistry.getInstance().containsComparator((Object)itemStack.m_41720_());
    }

    public boolean hasSubtypeInterpreter(@NotNull Object fluidStack) {
        return FluidComparatorRegistry.getInstance().containsComparator((Object)CompatPlatform.get().getFluid(fluidStack));
    }

    private static EntryComparator<ItemStack> wrapItemComparator(IIngredientSubtypeInterpreter<ItemStack> interpreter) {
        return (context, stack) -> {
            try {
                return Objects.hashCode(interpreter.apply((ItemStack)stack, JEIPluginDetector.wrapContext(context)));
            }
            catch (NullPointerException e) {
                return 0L;
            }
        };
    }

    private static EntryComparator<FluidStack> wrapFluidComparator(IIngredientSubtypeInterpreter<Object> interpreter) {
        return (context, stack) -> {
            try {
                return Objects.hashCode(interpreter.apply(CompatPlatform.get().toPlatformFluidStack((FluidStack)stack), JEIPluginDetector.wrapContext(context)));
            }
            catch (NullPointerException e) {
                return 0L;
            }
        };
    }
}

