/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredientManager;
import me.shedaniel.rei.jeicompat.wrap.JEIIngredientVisibility;
import me.shedaniel.rei.jeicompat.wrap.JEIJeiHelpers;
import me.shedaniel.rei.jeicompat.wrap.JEIVanillaRecipeFactory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IIngredientVisibility;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JEIRecipeRegistration
implements IRecipeRegistration {
    private final List<Runnable> post;

    public JEIRecipeRegistration(List<Runnable> post) {
        this.post = post;
    }

    @Override
    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return JEIJeiHelpers.INSTANCE;
    }

    @Override
    @NotNull
    public IIngredientManager getIngredientManager() {
        return JEIIngredientManager.INSTANCE;
    }

    @Override
    @NotNull
    public IVanillaRecipeFactory getVanillaRecipeFactory() {
        return JEIVanillaRecipeFactory.INSTANCE;
    }

    @Override
    public IIngredientVisibility getIngredientVisibility() {
        return JEIIngredientVisibility.INSTANCE;
    }

    public static <T> void addRecipes0(@NotNull Collection<?> recipes, @NotNull ResourceLocation categoryId) {
        CategoryIdentifier categoryIdentifier = JEIPluginDetector.categoryId(categoryId);
        DisplayRegistry registry = DisplayRegistry.getInstance();
        Function<Object, Collection<Display>> displayFiller = JEIRecipeRegistration.createDisplayFiller(categoryIdentifier, registry);
        if (JEIRecipeRegistration.canRecipesBeMultithreaded(recipes, categoryIdentifier)) {
            JEIRecipeRegistration.addRecipesOptimized((List)recipes, categoryIdentifier, registry, displayFiller);
            return;
        }
        for (Object recipe : recipes) {
            Collection<Display> displays = displayFiller.apply(recipe);
            if (displays.isEmpty()) {
                InternalLogger.getInstance().warn("No displays found for recipe: %s for category %s", new Object[]{recipe, categoryIdentifier});
                return;
            }
            boolean registered = false;
            for (Display display : displays) {
                if (!Objects.equals(display.getCategoryIdentifier(), categoryIdentifier)) continue;
                registry.add(display, recipe);
                registered = true;
            }
            if (registered) continue;
            InternalLogger.getInstance().warn("No displays matched category for recipe: %s for category %s", new Object[]{recipe, categoryIdentifier});
        }
    }

    private static Function<Object, Collection<Display>> createDisplayFiller(CategoryIdentifier<Display> categoryIdentifier, DisplayRegistry registry) {
        CategoryRegistry categoryRegistry = CategoryRegistry.getInstance();
        Optional optionalCategory = categoryRegistry.tryGet(categoryIdentifier);
        boolean isJEICategory = optionalCategory.isPresent() && ((CategoryRegistry.CategoryConfiguration)optionalCategory.get()).getCategory() instanceof JEIWrappedCategory;
        Function<Object, Collection<Display>> displayFiller = recipe -> JEIRecipeRegistration.fillDisplaysFromJEI(recipe, registry);
        if (isJEICategory) {
            JEIWrappedCategory category = (JEIWrappedCategory)((CategoryRegistry.CategoryConfiguration)optionalCategory.get()).getCategory();
            Class recipeClass = category.getRecipeClass();
            return recipe -> {
                if (recipeClass.isInstance(recipe) && category.handlesRecipe(recipe)) {
                    return List.of(new JEIWrappedDisplay<Object>(category, recipe));
                }
                return (Collection)displayFiller.apply(recipe);
            };
        }
        return displayFiller;
    }

    private static Collection<Display> fillDisplaysFromJEI(Object recipe, DisplayRegistry registry) {
        return registry.tryFillDisplay(recipe);
    }

    private static boolean canRecipesBeMultithreaded(@NotNull Collection<?> recipes, CategoryIdentifier<Display> categoryIdentifier) {
        if (categoryIdentifier.getNamespace().equals("tfc")) {
            return false;
        }
        return recipes instanceof List && recipes.size() >= 100;
    }

    @Override
    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        this.post.add(() -> JEIRecipeRegistration.addRecipes0(recipes, recipeType.getUid()));
    }

    private static void addRecipesOptimized(List<Object> recipes, @NotNull CategoryIdentifier<?> categoryId, DisplayRegistry registry, Function<Object, Collection<Display>> displayFiller) {
        ArrayList completableFutures = Lists.newArrayList();
        Function<Object, Supplier> tryFillDisplay = o -> {
            try {
                Collection displays = (Collection)displayFiller.apply(o);
                return () -> displays;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof ConcurrentModificationException) {
                    InternalLogger.getInstance().debug("Failed to parallelize recipe: %s for category %s", new Object[]{o, categoryId});
                    return () -> (Collection)displayFiller.apply(o);
                }
                throw e;
            }
        };
        CollectionUtils.partition(recipes, (int)50).forEach(list -> completableFutures.add(CompletableFuture.supplyAsync(() -> CollectionUtils.map((Collection)list, (Function)tryFillDisplay))));
        try {
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        int i = 0;
        boolean contains = false;
        boolean registered = false;
        for (CompletableFuture future : completableFutures) {
            List displayCollection = future.getNow(null);
            if (displayCollection != null) {
                int j = 0;
                for (Supplier displays : displayCollection) {
                    Object origin = recipes.get(i * 50 + j);
                    for (Display display : (Collection)displays.get()) {
                        if (!Objects.equals(display.getCategoryIdentifier(), categoryId)) continue;
                        registry.add(display, origin);
                        registered = true;
                    }
                }
                if (displayCollection.size() > 0) {
                    contains = true;
                }
            }
            ++i;
        }
        if (!contains) {
            InternalLogger.getInstance().warn("No displays found for recipes: %s for category %s", new Object[]{recipes.stream().map(Objects::toString).collect(Collectors.joining(", ")), categoryId});
        } else if (!registered) {
            InternalLogger.getInstance().warn("No displays matched category for recipes: %s for category %s", new Object[]{recipes.stream().map(Objects::toString).collect(Collectors.joining(", ")), categoryId});
        }
    }

    @Override
    public <T> void addIngredientInfo(@NotNull T ingredient, @NotNull IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        EntryStack<T> stack = JEIPluginDetector.unwrapStack(ingredient, ingredientType);
        BuiltinClientPlugin.getInstance().registerInformation(stack, stack.asFormattedText(), components -> {
            Collections.addAll(components, descriptionComponents);
            return components;
        });
    }

    @Override
    public <T> void addIngredientInfo(@NotNull List<T> ingredients, @NotNull IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        EntryIngredient ingredient = JEIPluginDetector.unwrapList(ingredientType, ingredients);
        BuiltinClientPlugin.getInstance().registerInformation(ingredient, (Component)Component.m_237119_(), components -> {
            Collections.addAll(components, descriptionComponents);
            return components;
        });
    }
}

