/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IRecipeCatalystLookup;

public class JEICatalystLookup
implements IRecipeCatalystLookup {
    private final CategoryIdentifier<?> category;
    private boolean includeHidden = false;

    public JEICatalystLookup(CategoryIdentifier<?> category) {
        this.category = category;
    }

    @Override
    public IRecipeCatalystLookup includeHidden() {
        this.includeHidden = true;
        return this;
    }

    @Override
    public Stream<ITypedIngredient<?>> get() {
        Stream<Object> stream = CategoryRegistry.getInstance().get(this.category).getWorkstations().stream().flatMap(Collection::stream);
        if (this.includeHidden) {
            return stream.map(entry -> JEIPluginDetector.typedJeiValue(entry));
        }
        EntryRegistry registry = EntryRegistry.getInstance();
        return EntryRegistry.getInstance().refilterNew(false, (Collection)stream.collect(Collectors.toList())).stream().map(entry -> JEIPluginDetector.typedJeiValue(entry));
    }

    @Override
    public <S> Stream<S> get(IIngredientType<S> ingredientType) {
        return this.get().map(entry -> entry.getIngredient(ingredientType)).flatMap(Optional::stream);
    }
}

