/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.OptionalInt;
import me.shedaniel.rei.jeicompat.CompatPlatform;
import me.shedaniel.rei.jeicompat.wrap.JEIPlatformFluidHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class CompatPlatformReal
implements CompatPlatform {
    @Override
    public <T> IPlatformFluidHelper<T> getPlatformFluidHelper() {
        return JEIPlatformFluidHelper.INSTANCE;
    }

    @Override
    public Class<?> getPlatformFluidStackClass() {
        return net.minecraftforge.fluids.FluidStack.class;
    }

    @Override
    public FluidStack fromPlatformFluidStack(Object fluidStack) {
        return FluidStackHooksForge.fromForge((net.minecraftforge.fluids.FluidStack)((net.minecraftforge.fluids.FluidStack)fluidStack));
    }

    @Override
    public Object toPlatformFluidStack(FluidStack fluidStack) {
        return FluidStackHooksForge.toForge((FluidStack)fluidStack);
    }

    @Override
    public Fluid getFluid(Object fluidStack) {
        return ((net.minecraftforge.fluids.FluidStack)fluidStack).getFluid();
    }

    @Override
    public OptionalInt getWidthFromRecipe(Recipe<?> recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            return OptionalInt.of(shapedRecipe.getRecipeWidth());
        }
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt getHeightFromRecipe(Recipe<?> recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            return OptionalInt.of(shapedRecipe.getRecipeHeight());
        }
        return OptionalInt.empty();
    }

    @Override
    public Font getTooltipFontFromItemStack(ItemStack stack) {
        return IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.TOOLTIP);
    }

    @Override
    public int getGuiLeft(AbstractContainerScreen<?> screen) {
        return screen.getGuiLeft();
    }

    @Override
    public int getGuiTop(AbstractContainerScreen<?> screen) {
        return screen.getGuiTop();
    }
}

