/*
 * Decompiled with CFR 0.152.
 */
package com.leo.powerpots.init;

import com.leo.powerpots.block.PotTier;
import com.leo.powerpots.block.PowerPotBlock;
import com.leo.powerpots.config.Config;
import com.leo.powerpots.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"powerpots");
    public static List<RegistryObject<Block>> POWER_BLOCKS = new ArrayList<RegistryObject<Block>>();

    public static Block[] getBlocks() {
        return (Block[])POWER_BLOCKS.stream().map(RegistryObject::get).toArray(Block[]::new);
    }

    public static void register(IEventBus bus) {
        for (PotTier tier : Config.INSTANCE.TIERS) {
            if (tier.index() == 0) continue;
            POWER_BLOCKS.add(ModBlocks.registerBlock("power_pot_" + tier.index(), () -> new PowerPotBlock(tier)));
        }
        BLOCKS.register(bus);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

