/*
 * Decompiled with CFR 0.152.
 */
package com.leo.powerpots.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.leo.powerpots.PowerPots;
import com.leo.powerpots.block.PotTier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    public static Config INSTANCE;
    @Expose
    private PotTier[] tiers = new PotTier[]{new PotTier(1, 1000, 10, 2, 1), new PotTier(2, 2000, 20, 4, 2), new PotTier(3, 4000, 40, 8, 4)};
    @Expose
    public List<PotTier> TIERS = new ArrayList<PotTier>();

    public static void initialize() {
        Config config = new Config();
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("PowerPots.json");
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                config = (Config)gson.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                System.err.println("Failed to read config, using defaults: " + e.getMessage());
            }
        } else {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                PowerPots.LOGGER.info("Config file not found. Creating a new one with default values.");
            }
            catch (IOException e) {
                PowerPots.LOGGER.error("Failed to create config directory: {}", (Object)e.getMessage());
            }
        }
        if (config == null) {
            config = new Config();
        }
        INSTANCE = config;
        INSTANCE.onConfigLoaded();
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            gson.toJson((Object)INSTANCE, (Appendable)writer);
            PowerPots.LOGGER.info("Configuration saved to: {}", (Object)configPath);
        }
        catch (IOException e) {
            PowerPots.LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    private void onConfigLoaded() {
        this.TIERS.clear();
        if (this.tiers != null) {
            this.TIERS.addAll(Arrays.asList(this.tiers));
        }
    }
}

